/*
 * Decompiled with CFR 0.152.
 */
package io.github.memfis19.annca.internal.ui.view;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.FrameLayout;
import io.github.memfis19.annca.internal.utils.Size;

public class AspectFrameLayout
extends FrameLayout {
    private static final String TAG = "AspectFrameLayout";
    private double targetAspectRatio = -1.0;
    private Size size = null;
    private int actualPreviewWidth;
    private int actualPreviewHeight;

    public AspectFrameLayout(Context context) {
        super(context);
    }

    public AspectFrameLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public void setAspectRatio(double aspectRatio) {
        if (aspectRatio < 0.0) {
            throw new IllegalArgumentException();
        }
        if (this.targetAspectRatio != aspectRatio) {
            this.targetAspectRatio = aspectRatio;
            this.requestLayout();
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (this.size != null) {
            this.setMeasuredDimension(this.size.getWidth(), this.size.getHeight());
            return;
        }
        if (this.targetAspectRatio > 0.0) {
            int verticalPadding;
            int initialWidth = View.MeasureSpec.getSize((int)widthMeasureSpec);
            int initialHeight = View.MeasureSpec.getSize((int)heightMeasureSpec);
            int horizontalPadding = this.getPaddingLeft() + this.getPaddingRight();
            double viewAspectRatio = (double)(initialWidth -= horizontalPadding) / (double)(initialHeight -= (verticalPadding = this.getPaddingTop() + this.getPaddingBottom()));
            double aspectDifference = this.targetAspectRatio / viewAspectRatio - 1.0;
            if (!(Math.abs(aspectDifference) < 0.01)) {
                if (aspectDifference > 0.0) {
                    initialHeight = (int)((double)initialWidth / this.targetAspectRatio);
                } else {
                    initialWidth = (int)((double)initialHeight * this.targetAspectRatio);
                }
                widthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)(initialWidth += horizontalPadding), (int)0x40000000);
                heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)(initialHeight += verticalPadding), (int)0x40000000);
            }
        }
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        if (this.size != null && this.getChildAt(0) != null) {
            this.getChildAt(0).layout(0, 0, this.actualPreviewWidth, this.actualPreviewHeight);
        } else {
            super.onLayout(changed, l, t, r, b);
        }
    }

    public void setCustomSize(final Size size, Size previewSize) {
        if (this.targetAspectRatio <= 0.0) {
            this.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

                public void onGlobalLayout() {
                    AspectFrameLayout.this.getViewTreeObserver().removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                    AspectFrameLayout.this.actualPreviewWidth = AspectFrameLayout.this.getMeasuredWidth();
                    AspectFrameLayout.this.actualPreviewHeight = AspectFrameLayout.this.getMeasuredHeight();
                    if (AspectFrameLayout.this.actualPreviewHeight < AspectFrameLayout.this.actualPreviewWidth) {
                        AspectFrameLayout.this.size = new Size(AspectFrameLayout.this.actualPreviewHeight, AspectFrameLayout.this.actualPreviewHeight);
                    } else {
                        AspectFrameLayout.this.size = new Size(AspectFrameLayout.this.actualPreviewWidth, AspectFrameLayout.this.actualPreviewWidth);
                    }
                    ViewGroup.LayoutParams layoutParams = AspectFrameLayout.this.getLayoutParams();
                    layoutParams.width = size.getWidth();
                    layoutParams.height = size.getHeight();
                    AspectFrameLayout.this.setLayoutParams(layoutParams);
                    AspectFrameLayout.this.requestLayout();
                }
            });
            this.setAspectRatio((double)previewSize.getHeight() / (double)previewSize.getWidth());
        }
    }

    public int getCroppSize() {
        return this.size.getHeight();
    }

    public void getCameraViewLocation(int[] location) {
        if (this.getChildAt(0) != null) {
            this.getChildAt(0).getLocationInWindow(location);
        } else {
            this.getLocationInWindow(location);
        }
    }
}

