/*
 * Decompiled with CFR 0.152.
 */
package io.github.memfis19.annca.internal.controller.impl;

import android.content.Context;
import android.hardware.Camera;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import android.view.SurfaceHolder;
import android.view.View;
import io.github.memfis19.annca.internal.configuration.ConfigurationProvider;
import io.github.memfis19.annca.internal.controller.CameraController;
import io.github.memfis19.annca.internal.controller.view.CameraView;
import io.github.memfis19.annca.internal.manager.CameraManager;
import io.github.memfis19.annca.internal.manager.impl.Camera1Manager;
import io.github.memfis19.annca.internal.manager.listener.CameraCloseListener;
import io.github.memfis19.annca.internal.manager.listener.CameraOpenListener;
import io.github.memfis19.annca.internal.manager.listener.CameraPhotoListener;
import io.github.memfis19.annca.internal.manager.listener.CameraVideoListener;
import io.github.memfis19.annca.internal.ui.view.AutoFitSurfaceView;
import io.github.memfis19.annca.internal.utils.CameraHelper;
import io.github.memfis19.annca.internal.utils.Size;
import java.io.File;

public class Camera1Controller
implements CameraController<Integer>,
CameraOpenListener<Integer, SurfaceHolder.Callback>,
CameraPhotoListener,
CameraCloseListener<Integer>,
CameraVideoListener {
    private static final String TAG = "Camera1Controller";
    private Integer currentCameraId;
    private ConfigurationProvider configurationProvider;
    private CameraManager<Integer, SurfaceHolder.Callback, Camera.Parameters, Camera> cameraManager;
    private CameraView cameraView;
    private File outputFile;

    public Camera1Controller(CameraView cameraView, ConfigurationProvider configurationProvider) {
        this.cameraView = cameraView;
        this.configurationProvider = configurationProvider;
    }

    @Override
    public void onCreate(Bundle savedInstanceState) {
        this.cameraManager = Camera1Manager.getInstance();
        this.cameraManager.initializeCameraManager(this.configurationProvider, (Context)this.cameraView.getActivity());
        this.currentCameraId = this.configurationProvider.getCameraFace() == 0 ? (this.cameraManager.getFaceFrontCameraId() == null ? this.cameraManager.getFaceBackCameraId() : this.cameraManager.getFaceFrontCameraId()) : this.cameraManager.getFaceBackCameraId();
    }

    @Override
    public void onResume() {
        this.cameraManager.openCamera(this.currentCameraId, this);
    }

    @Override
    public void onPause() {
        this.cameraManager.closeCamera(null);
    }

    @Override
    public void onDestroy() {
        this.cameraManager.releaseCameraManager();
    }

    @Override
    public void takePhoto() {
        this.outputFile = TextUtils.isEmpty((CharSequence)this.configurationProvider.getFilePath()) ? CameraHelper.getOutputMediaFile((Context)this.cameraView.getActivity(), 101) : new File(this.configurationProvider.getFilePath());
        this.cameraManager.takePhoto(this.outputFile, this);
    }

    @Override
    public void startVideoRecord() {
        this.outputFile = TextUtils.isEmpty((CharSequence)this.configurationProvider.getFilePath()) ? CameraHelper.getOutputMediaFile((Context)this.cameraView.getActivity(), 100) : new File(this.configurationProvider.getFilePath());
        this.cameraManager.startVideoRecord(this.outputFile, this);
    }

    @Override
    public void stopVideoRecord() {
        this.cameraManager.stopVideoRecord();
    }

    @Override
    public boolean isVideoRecording() {
        return this.cameraManager.isVideoRecording();
    }

    @Override
    public void switchCamera(int cameraFace) {
        this.currentCameraId = this.cameraManager.getCurrentCameraId().equals(this.cameraManager.getFaceFrontCameraId()) ? this.cameraManager.getFaceBackCameraId() : this.cameraManager.getFaceFrontCameraId();
        this.cameraManager.closeCamera(this);
    }

    @Override
    public void setFlashMode(int flashMode) {
        this.cameraManager.setFlashMode(flashMode);
    }

    @Override
    public void switchQuality() {
        this.cameraManager.closeCamera(this);
    }

    @Override
    public int getNumberOfCameras() {
        return this.cameraManager.getNumberOfCameras();
    }

    @Override
    public int getMediaAction() {
        return this.configurationProvider.getMediaAction();
    }

    @Override
    public File getOutputFile() {
        return this.outputFile;
    }

    @Override
    public Integer getCurrentCameraId() {
        return this.currentCameraId;
    }

    @Override
    public void onCameraOpened(Integer cameraId, Size previewSize, SurfaceHolder.Callback surfaceCallback) {
        this.cameraView.updateUiForMediaAction(this.configurationProvider.getMediaAction());
        this.cameraView.updateCameraPreview(previewSize, (View)new AutoFitSurfaceView((Context)this.cameraView.getActivity(), surfaceCallback));
        this.cameraView.updateCameraSwitcher(this.getNumberOfCameras());
    }

    @Override
    public void onCameraReady() {
        this.cameraView.onCameraReady();
    }

    @Override
    public void onCameraOpenError() {
        Log.e((String)TAG, (String)"onCameraOpenError");
    }

    @Override
    public void onCameraClosed(Integer closedCameraId) {
        this.cameraView.releaseCameraPreview();
        this.cameraManager.openCamera(this.currentCameraId, this);
    }

    @Override
    public void onPhotoTaken(File photoFile) {
        this.cameraView.onPhotoTaken();
    }

    @Override
    public void onPhotoTakeError() {
    }

    @Override
    public void onVideoRecordStarted(Size videoSize) {
        this.cameraView.onVideoRecordStart(videoSize.getWidth(), videoSize.getHeight());
    }

    @Override
    public void onVideoRecordStopped(File videoFile) {
        this.cameraView.onVideoRecordStop();
    }

    @Override
    public void onVideoRecordError() {
    }

    @Override
    public CameraManager getCameraManager() {
        return this.cameraManager;
    }
}

