/*
 * Decompiled with CFR 0.152.
 */
package io.github.memfis19.annca.internal.ui.camera;

import android.media.CamcorderProfile;
import io.github.memfis19.annca.internal.configuration.ConfigurationProvider;
import io.github.memfis19.annca.internal.controller.CameraController;
import io.github.memfis19.annca.internal.controller.impl.Camera1Controller;
import io.github.memfis19.annca.internal.controller.view.CameraView;
import io.github.memfis19.annca.internal.ui.BaseAnncaActivity;
import io.github.memfis19.annca.internal.ui.model.PhotoQualityOption;
import io.github.memfis19.annca.internal.ui.model.VideoQualityOption;
import io.github.memfis19.annca.internal.utils.CameraHelper;
import java.util.ArrayList;

public class Camera1Activity
extends BaseAnncaActivity<Integer> {
    @Override
    public CameraController<Integer> createCameraController(CameraView cameraView, ConfigurationProvider configurationProvider) {
        return new Camera1Controller(cameraView, configurationProvider);
    }

    @Override
    protected CharSequence[] getVideoQualityOptions() {
        ArrayList<VideoQualityOption> videoQualities = new ArrayList<VideoQualityOption>();
        if (this.getMinimumVideoDuration() > 0) {
            videoQualities.add(new VideoQualityOption(10, CameraHelper.getCamcorderProfile(10, (Integer)this.getCameraController().getCurrentCameraId()), this.getMinimumVideoDuration()));
        }
        CamcorderProfile camcorderProfile = CameraHelper.getCamcorderProfile(13, (Integer)this.getCameraController().getCurrentCameraId());
        double videoDuration = CameraHelper.calculateApproximateVideoDuration(camcorderProfile, this.getVideoFileSize());
        videoQualities.add(new VideoQualityOption(13, camcorderProfile, videoDuration));
        camcorderProfile = CameraHelper.getCamcorderProfile(12, (Integer)this.getCameraController().getCurrentCameraId());
        videoDuration = CameraHelper.calculateApproximateVideoDuration(camcorderProfile, this.getVideoFileSize());
        videoQualities.add(new VideoQualityOption(12, camcorderProfile, videoDuration));
        camcorderProfile = CameraHelper.getCamcorderProfile(11, (Integer)this.getCameraController().getCurrentCameraId());
        videoDuration = CameraHelper.calculateApproximateVideoDuration(camcorderProfile, this.getVideoFileSize());
        videoQualities.add(new VideoQualityOption(11, camcorderProfile, videoDuration));
        CharSequence[] array = new CharSequence[videoQualities.size()];
        videoQualities.toArray(array);
        return array;
    }

    @Override
    protected CharSequence[] getPhotoQualityOptions() {
        ArrayList<PhotoQualityOption> photoQualities = new ArrayList<PhotoQualityOption>();
        photoQualities.add(new PhotoQualityOption(14, this.getCameraController().getCameraManager().getPhotoSizeForQuality(14)));
        photoQualities.add(new PhotoQualityOption(13, this.getCameraController().getCameraManager().getPhotoSizeForQuality(13)));
        photoQualities.add(new PhotoQualityOption(12, this.getCameraController().getCameraManager().getPhotoSizeForQuality(12)));
        photoQualities.add(new PhotoQualityOption(15, this.getCameraController().getCameraManager().getPhotoSizeForQuality(15)));
        CharSequence[] array = new CharSequence[photoQualities.size()];
        photoQualities.toArray(array);
        return array;
    }
}

