/*
 * Decompiled with CFR 0.152.
 */
package io.github.memfis19.annca.internal.ui.view;

import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.v4.content.ContextCompat;
import android.support.v4.graphics.drawable.DrawableCompat;
import android.support.v7.widget.AppCompatImageButton;
import android.util.AttributeSet;
import android.view.View;
import io.github.memfis19.annca.R;
import io.github.memfis19.annca.internal.utils.Utils;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class CameraSwitchView
extends AppCompatImageButton {
    public static final int CAMERA_TYPE_FRONT = 0;
    public static final int CAMERA_TYPE_REAR = 1;
    private OnCameraTypeChangeListener onCameraTypeChangeListener;
    private Context context;
    private Drawable frontCameraDrawable;
    private Drawable rearCameraDrawable;
    private int padding = 5;
    private int currentCameraType = 1;

    public CameraSwitchView(Context context) {
        this(context, null);
    }

    public CameraSwitchView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.context = context;
        this.initializeView();
    }

    public CameraSwitchView(Context context, AttributeSet attrs, int defStyleAttr) {
        this(context, attrs);
    }

    private void initializeView() {
        this.frontCameraDrawable = ContextCompat.getDrawable((Context)this.context, (int)R.drawable.ic_camera_front_white_24dp);
        this.frontCameraDrawable = DrawableCompat.wrap((Drawable)this.frontCameraDrawable);
        DrawableCompat.setTintList((Drawable)this.frontCameraDrawable.mutate(), (ColorStateList)ContextCompat.getColorStateList((Context)this.context, (int)R.drawable.switch_camera_mode_selector));
        this.rearCameraDrawable = ContextCompat.getDrawable((Context)this.context, (int)R.drawable.ic_camera_rear_white_24dp);
        this.rearCameraDrawable = DrawableCompat.wrap((Drawable)this.rearCameraDrawable);
        DrawableCompat.setTintList((Drawable)this.rearCameraDrawable.mutate(), (ColorStateList)ContextCompat.getColorStateList((Context)this.context, (int)R.drawable.switch_camera_mode_selector));
        this.setBackgroundResource(R.drawable.circle_frame_background_dark);
        this.setOnClickListener(new CameraTypeClickListener());
        this.setIcons();
        this.padding = Utils.convertDipToPixels(this.context, this.padding);
        this.setPadding(this.padding, this.padding, this.padding, this.padding);
    }

    private void setIcons() {
        if (this.currentCameraType == 1) {
            this.setImageDrawable(this.frontCameraDrawable);
        } else {
            this.setImageDrawable(this.rearCameraDrawable);
        }
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (Build.VERSION.SDK_INT > 10) {
            if (enabled) {
                this.setAlpha(1.0f);
            } else {
                this.setAlpha(0.5f);
            }
        }
    }

    public void setCameraType(int cameraType) {
        this.currentCameraType = cameraType;
        this.setIcons();
    }

    public int getCameraType() {
        return this.currentCameraType;
    }

    public void setOnCameraTypeChangeListener(OnCameraTypeChangeListener onCameraTypeChangeListener) {
        this.onCameraTypeChangeListener = onCameraTypeChangeListener;
    }

    private class CameraTypeClickListener
    implements View.OnClickListener {
        private CameraTypeClickListener() {
        }

        public void onClick(View view) {
            if (CameraSwitchView.this.currentCameraType == 1) {
                CameraSwitchView.this.currentCameraType = 0;
            } else {
                CameraSwitchView.this.currentCameraType = 1;
            }
            CameraSwitchView.this.setIcons();
            if (CameraSwitchView.this.onCameraTypeChangeListener != null) {
                CameraSwitchView.this.onCameraTypeChangeListener.onCameraTypeChanged(CameraSwitchView.this.currentCameraType);
            }
        }
    }

    public static interface OnCameraTypeChangeListener {
        public void onCameraTypeChanged(int var1);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface CameraType {
    }
}

