/*
 * Decompiled with CFR 0.152.
 */
package io.github.memfis19.annca.internal.configuration;

import android.app.Activity;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.v4.app.Fragment;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public final class AnncaConfiguration {
    public static final int MEDIA_QUALITY_AUTO = 10;
    public static final int MEDIA_QUALITY_LOWEST = 15;
    public static final int MEDIA_QUALITY_LOW = 11;
    public static final int MEDIA_QUALITY_MEDIUM = 12;
    public static final int MEDIA_QUALITY_HIGH = 13;
    public static final int MEDIA_QUALITY_HIGHEST = 14;
    public static final int MEDIA_ACTION_VIDEO = 100;
    public static final int MEDIA_ACTION_PHOTO = 101;
    public static final int MEDIA_ACTION_UNSPECIFIED = 102;
    public static final int CAMERA_FACE_FRONT = 6;
    public static final int CAMERA_FACE_REAR = 7;
    public static final int SENSOR_POSITION_UP = 90;
    public static final int SENSOR_POSITION_UP_SIDE_DOWN = 270;
    public static final int SENSOR_POSITION_LEFT = 0;
    public static final int SENSOR_POSITION_RIGHT = 180;
    public static final int SENSOR_POSITION_UNSPECIFIED = -1;
    public static final int DISPLAY_ROTATION_0 = 0;
    public static final int DISPLAY_ROTATION_90 = 90;
    public static final int DISPLAY_ROTATION_180 = 180;
    public static final int DISPLAY_ROTATION_270 = 270;
    public static final int ORIENTATION_PORTRAIT = 273;
    public static final int ORIENTATION_LANDSCAPE = 546;
    public static final int FLASH_MODE_ON = 1;
    public static final int FLASH_MODE_OFF = 2;
    public static final int FLASH_MODE_AUTO = 3;
    private Activity activity = null;
    private Fragment fragment = null;
    private int requestCode = -1;
    private int mediaAction = -1;
    private int mediaQuality = -1;
    private int cameraFace = -1;
    private int videoDuration = -1;
    private long videoFileSize = -1L;
    private int minimumVideoDuration = -1;
    private int flashMode = 3;

    private AnncaConfiguration(Activity activity, int requestCode) {
        this.activity = activity;
        this.requestCode = requestCode;
    }

    private AnncaConfiguration(@NonNull Fragment fragment, int requestCode) {
        this.fragment = fragment;
        this.requestCode = requestCode;
    }

    public Activity getActivity() {
        return this.activity;
    }

    public Fragment getFragment() {
        return this.fragment;
    }

    public int getRequestCode() {
        return this.requestCode;
    }

    public int getMediaAction() {
        return this.mediaAction;
    }

    public int getMediaQuality() {
        return this.mediaQuality;
    }

    public int getCameraFace() {
        return this.cameraFace;
    }

    public int getVideoDuration() {
        return this.videoDuration;
    }

    public long getVideoFileSize() {
        return this.videoFileSize;
    }

    public int getMinimumVideoDuration() {
        return this.minimumVideoDuration;
    }

    public int getFlashMode() {
        return this.flashMode;
    }

    public static class Builder {
        private AnncaConfiguration anncaConfiguration;

        public Builder(@NonNull Activity activity, @IntRange(from=0L) int requestCode) {
            this.anncaConfiguration = new AnncaConfiguration(activity, requestCode);
        }

        public Builder(@NonNull Fragment fragment, @IntRange(from=0L) int requestCode) {
            this.anncaConfiguration = new AnncaConfiguration(fragment, requestCode);
        }

        public Builder setMediaAction(int mediaAction) {
            this.anncaConfiguration.mediaAction = mediaAction;
            return this;
        }

        public Builder setMediaQuality(int mediaQuality) {
            this.anncaConfiguration.mediaQuality = mediaQuality;
            return this;
        }

        public Builder setVideoDuration(@IntRange(from=1000L, to=0x7FFFFFFFL) int videoDurationInMilliseconds) {
            this.anncaConfiguration.videoDuration = videoDurationInMilliseconds;
            return this;
        }

        public Builder setMinimumVideoDuration(@IntRange(from=1000L, to=0x7FFFFFFFL) int minimumVideoDurationInMilliseconds) {
            this.anncaConfiguration.minimumVideoDuration = minimumVideoDurationInMilliseconds;
            return this;
        }

        public Builder setVideoFileSize(@IntRange(from=0x100000L, to=0x7FFFFFFFFFFFFFFFL) long videoSizeInBytes) {
            this.anncaConfiguration.videoFileSize = videoSizeInBytes;
            return this;
        }

        public Builder setFlashMode(int flashMode) {
            this.anncaConfiguration.flashMode = flashMode;
            return this;
        }

        public AnncaConfiguration build() throws IllegalArgumentException {
            if (this.anncaConfiguration.requestCode < 0) {
                throw new IllegalArgumentException("Wrong request code value. Please set the value > 0.");
            }
            if (this.anncaConfiguration.mediaQuality == 10 && this.anncaConfiguration.minimumVideoDuration < 0) {
                throw new IllegalStateException("Please provide minimum video duration in milliseconds to use auto quality.");
            }
            return this.anncaConfiguration;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface DeviceDefaultOrientation {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface DisplayRotation {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SensorPosition {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface CameraFace {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface FlashMode {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface MediaAction {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface MediaQuality {
    }

    public static interface Arguments {
        public static final String REQUEST_CODE = "io.memfis19.annca.request_code";
        public static final String MEDIA_ACTION = "io.memfis19.annca.media_action";
        public static final String MEDIA_QUALITY = "io.memfis19.annca.camera_media_quality";
        public static final String VIDEO_DURATION = "io.memfis19.annca.video_duration";
        public static final String MINIMUM_VIDEO_DURATION = "io.memfis19.annca.minimum.video_duration";
        public static final String VIDEO_FILE_SIZE = "io.memfis19.annca.camera_video_file_size";
        public static final String FLASH_MODE = "io.memfis19.annca.camera_flash_mode";
        public static final String FILE_PATH = "io.memfis19.annca.camera_video_file_path";
    }
}

