/*
 * Decompiled with CFR 0.152.
 */
package io.github.memfis19.annca.internal.ui.preview;

import android.content.Context;
import android.content.Intent;
import android.media.MediaPlayer;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.app.AppCompatActivity;
import android.util.Log;
import android.view.MotionEvent;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.MediaController;
import android.widget.TextView;
import io.github.memfis19.annca.R;
import io.github.memfis19.annca.internal.ui.view.AspectFrameLayout;
import io.github.memfis19.annca.internal.utils.AnncaImageLoader;
import io.github.memfis19.annca.internal.utils.Utils;
import java.io.File;

public class PreviewActivity
extends AppCompatActivity
implements View.OnClickListener {
    private static final String TAG = "PreviewActivity";
    private static final String MEDIA_ACTION_ARG = "media_action_arg";
    private static final String FILE_PATH_ARG = "file_path_arg";
    private static final String RESPONSE_CODE_ARG = "response_code_arg";
    private static final String VIDEO_POSITION_ARG = "current_video_position";
    private static final String VIDEO_IS_PLAYED_ARG = "is_played";
    private static final String MIME_TYPE_VIDEO = "video";
    private static final String MIME_TYPE_IMAGE = "image";
    private int mediaAction;
    private String previewFilePath;
    private SurfaceView surfaceView;
    private FrameLayout photoPreviewContainer;
    private ImageView imagePreview;
    private ViewGroup buttonPanel;
    private AspectFrameLayout videoPreviewContainer;
    private View cropMediaAction;
    private TextView ratioChanger;
    private MediaController mediaController;
    private MediaPlayer mediaPlayer;
    private int currentPlaybackPosition = 0;
    private boolean isVideoPlaying = true;
    private int currentRatioIndex = 0;
    private float[] ratios;
    private String[] ratioLabels;
    private SurfaceHolder.Callback surfaceCallbacks = new SurfaceHolder.Callback(){

        public void surfaceCreated(SurfaceHolder holder) {
            PreviewActivity.this.showVideoPreview(holder);
        }

        public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
        }

        public void surfaceDestroyed(SurfaceHolder holder) {
        }
    };
    private MediaController.MediaPlayerControl MediaPlayerControlImpl = new MediaController.MediaPlayerControl(){

        public void start() {
            PreviewActivity.this.mediaPlayer.start();
        }

        public void pause() {
            PreviewActivity.this.mediaPlayer.pause();
        }

        public int getDuration() {
            return PreviewActivity.this.mediaPlayer.getDuration();
        }

        public int getCurrentPosition() {
            return PreviewActivity.this.mediaPlayer.getCurrentPosition();
        }

        public void seekTo(int pos) {
            PreviewActivity.this.mediaPlayer.seekTo(pos);
        }

        public boolean isPlaying() {
            return PreviewActivity.this.mediaPlayer.isPlaying();
        }

        public int getBufferPercentage() {
            return 0;
        }

        public boolean canPause() {
            return true;
        }

        public boolean canSeekBackward() {
            return true;
        }

        public boolean canSeekForward() {
            return true;
        }

        public int getAudioSessionId() {
            return PreviewActivity.this.mediaPlayer.getAudioSessionId();
        }
    };

    public static Intent newIntent(Context context, int mediaAction, String filePath) {
        return new Intent(context, PreviewActivity.class).putExtra(MEDIA_ACTION_ARG, mediaAction).putExtra(FILE_PATH_ARG, filePath);
    }

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_preview);
        String originalRatioLabel = this.getString(R.string.preview_controls_original_ratio_label);
        this.ratioLabels = new String[]{originalRatioLabel, "1:1", "4:3", "16:9"};
        this.ratios = new float[]{0.0f, 1.0f, 1.3333334f, 1.7777778f};
        this.surfaceView = (SurfaceView)this.findViewById(R.id.video_preview);
        this.surfaceView.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                if (PreviewActivity.this.mediaController == null) {
                    return false;
                }
                if (PreviewActivity.this.mediaController.isShowing()) {
                    PreviewActivity.this.mediaController.hide();
                    PreviewActivity.this.showButtonPanel(true);
                } else {
                    PreviewActivity.this.showButtonPanel(false);
                    PreviewActivity.this.mediaController.show();
                }
                return false;
            }
        });
        this.videoPreviewContainer = (AspectFrameLayout)this.findViewById(R.id.previewAspectFrameLayout);
        this.photoPreviewContainer = (FrameLayout)this.findViewById(R.id.photo_preview_container);
        this.buttonPanel = (ViewGroup)this.findViewById(R.id.preview_control_panel);
        View confirmMediaResult = this.findViewById(R.id.confirm_media_result);
        View reTakeMedia = this.findViewById(R.id.re_take_media);
        View cancelMediaAction = this.findViewById(R.id.cancel_media_action);
        this.cropMediaAction = this.findViewById(R.id.crop_image);
        this.ratioChanger = (TextView)this.findViewById(R.id.ratio_image);
        this.ratioChanger.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                PreviewActivity.this.currentRatioIndex = (PreviewActivity.this.currentRatioIndex + 1) % PreviewActivity.this.ratios.length;
                PreviewActivity.this.ratioChanger.setText((CharSequence)PreviewActivity.this.ratioLabels[PreviewActivity.this.currentRatioIndex]);
            }
        });
        this.cropMediaAction.setVisibility(8);
        this.ratioChanger.setVisibility(8);
        if (this.cropMediaAction != null) {
            this.cropMediaAction.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                }
            });
        }
        if (confirmMediaResult != null) {
            confirmMediaResult.setOnClickListener((View.OnClickListener)this);
        }
        if (reTakeMedia != null) {
            reTakeMedia.setOnClickListener((View.OnClickListener)this);
        }
        if (cancelMediaAction != null) {
            cancelMediaAction.setOnClickListener((View.OnClickListener)this);
        }
        Bundle args = this.getIntent().getExtras();
        this.mediaAction = args.getInt(MEDIA_ACTION_ARG);
        this.previewFilePath = args.getString(FILE_PATH_ARG);
        if (this.mediaAction == 100) {
            this.displayVideo(savedInstanceState);
        } else if (this.mediaAction == 101) {
            this.displayImage();
        } else {
            String mimeType = Utils.getMimeType(this.previewFilePath);
            if (mimeType.contains(MIME_TYPE_VIDEO)) {
                this.displayVideo(savedInstanceState);
            } else if (mimeType.contains(MIME_TYPE_IMAGE)) {
                this.displayImage();
            } else {
                this.finish();
            }
        }
    }

    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        this.saveVideoParams(outState);
    }

    protected void onDestroy() {
        super.onDestroy();
        if (this.mediaPlayer != null) {
            this.mediaPlayer.release();
            this.mediaPlayer = null;
        }
        if (this.mediaController != null) {
            this.mediaController.hide();
            this.mediaController = null;
        }
    }

    private void displayImage() {
        this.videoPreviewContainer.setVisibility(8);
        this.surfaceView.setVisibility(8);
        this.showImagePreview();
        this.ratioChanger.setText((CharSequence)this.ratioLabels[this.currentRatioIndex]);
    }

    private void showImagePreview() {
        this.imagePreview = new ImageView((Context)this);
        AnncaImageLoader.Builder builder = new AnncaImageLoader.Builder((Context)this);
        builder.load(this.previewFilePath).build().into(this.imagePreview);
        this.photoPreviewContainer.removeAllViews();
        this.photoPreviewContainer.addView((View)this.imagePreview);
    }

    private void displayVideo(Bundle savedInstanceState) {
        this.cropMediaAction.setVisibility(8);
        this.ratioChanger.setVisibility(8);
        if (savedInstanceState != null) {
            this.loadVideoParams(savedInstanceState);
        }
        this.photoPreviewContainer.setVisibility(8);
        this.surfaceView.getHolder().addCallback(this.surfaceCallbacks);
    }

    private void showVideoPreview(SurfaceHolder holder) {
        try {
            this.mediaPlayer = new MediaPlayer();
            this.mediaPlayer.setDataSource(this.previewFilePath);
            this.mediaPlayer.setDisplay(holder);
            this.mediaPlayer.setAudioStreamType(3);
            this.mediaPlayer.setOnPreparedListener(new MediaPlayer.OnPreparedListener(){

                public void onPrepared(MediaPlayer mp) {
                    PreviewActivity.this.mediaController = new MediaController((Context)PreviewActivity.this);
                    PreviewActivity.this.mediaController.setAnchorView((View)PreviewActivity.this.surfaceView);
                    PreviewActivity.this.mediaController.setMediaPlayer(PreviewActivity.this.MediaPlayerControlImpl);
                    int videoWidth = mp.getVideoWidth();
                    int videoHeight = mp.getVideoHeight();
                    PreviewActivity.this.videoPreviewContainer.setAspectRatio((double)videoWidth / (double)videoHeight);
                    PreviewActivity.this.mediaPlayer.start();
                    PreviewActivity.this.mediaPlayer.seekTo(PreviewActivity.this.currentPlaybackPosition);
                    if (!PreviewActivity.this.isVideoPlaying) {
                        PreviewActivity.this.mediaPlayer.pause();
                    }
                }
            });
            this.mediaPlayer.setOnErrorListener(new MediaPlayer.OnErrorListener(){

                public boolean onError(MediaPlayer mp, int what, int extra) {
                    PreviewActivity.this.finish();
                    return true;
                }
            });
            this.mediaPlayer.prepareAsync();
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"Error media player playing video.");
            this.finish();
        }
    }

    private void saveVideoParams(Bundle outState) {
        if (this.mediaPlayer != null) {
            outState.putInt(VIDEO_POSITION_ARG, this.mediaPlayer.getCurrentPosition());
            outState.putBoolean(VIDEO_IS_PLAYED_ARG, this.mediaPlayer.isPlaying());
        }
    }

    private void loadVideoParams(Bundle savedInstanceState) {
        this.currentPlaybackPosition = savedInstanceState.getInt(VIDEO_POSITION_ARG, 0);
        this.isVideoPlaying = savedInstanceState.getBoolean(VIDEO_IS_PLAYED_ARG, true);
    }

    private void showButtonPanel(boolean show) {
        if (show) {
            this.buttonPanel.setVisibility(0);
        } else {
            this.buttonPanel.setVisibility(8);
        }
    }

    public void onClick(View view) {
        Intent resultIntent = new Intent();
        if (view.getId() == R.id.confirm_media_result) {
            resultIntent.putExtra(RESPONSE_CODE_ARG, 900).putExtra(FILE_PATH_ARG, this.previewFilePath);
        } else if (view.getId() == R.id.re_take_media) {
            this.deleteMediaFile();
            resultIntent.putExtra(RESPONSE_CODE_ARG, 901);
        } else if (view.getId() == R.id.cancel_media_action) {
            this.deleteMediaFile();
            resultIntent.putExtra(RESPONSE_CODE_ARG, 902);
        }
        this.setResult(-1, resultIntent);
        this.finish();
    }

    public void onBackPressed() {
        super.onBackPressed();
        this.deleteMediaFile();
    }

    private boolean deleteMediaFile() {
        File mediaFile = new File(this.previewFilePath);
        return mediaFile.delete();
    }

    public static boolean isResultConfirm(@NonNull Intent resultIntent) {
        return 900 == resultIntent.getIntExtra(RESPONSE_CODE_ARG, -1);
    }

    public static String getMediaFilePatch(@NonNull Intent resultIntent) {
        return resultIntent.getStringExtra(FILE_PATH_ARG);
    }

    public static boolean isResultRetake(@NonNull Intent resultIntent) {
        return 901 == resultIntent.getIntExtra(RESPONSE_CODE_ARG, -1);
    }

    public static boolean isResultCancel(@NonNull Intent resultIntent) {
        return 902 == resultIntent.getIntExtra(RESPONSE_CODE_ARG, -1);
    }
}

