/*
 * Decompiled with CFR 0.152.
 */
package io.github.memfis19.annca.internal.manager.impl;

import android.content.Context;
import android.media.CamcorderProfile;
import android.media.MediaRecorder;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.util.Log;
import io.github.memfis19.annca.internal.configuration.ConfigurationProvider;
import io.github.memfis19.annca.internal.manager.CameraManager;

abstract class BaseCameraManager<CameraId, Size, SurfaceListener>
implements CameraManager<CameraId, Size, SurfaceListener>,
MediaRecorder.OnInfoListener {
    private static final String TAG = "BaseCameraManager";
    protected Context context;
    ConfigurationProvider configurationProvider;
    MediaRecorder videoRecorder;
    boolean isVideoRecording = false;
    CameraId currentCameraId = null;
    CameraId faceFrontCameraId = null;
    CameraId faceBackCameraId = null;
    int numberOfCameras = 0;
    int faceFrontCameraOrientation;
    int faceBackCameraOrientation;
    CamcorderProfile camcorderProfile;
    Size photoSize;
    Size videoSize;
    Size previewSize;
    Size windowSize;
    HandlerThread backgroundThread;
    Handler backgroundHandler;
    Handler uiHandler = new Handler(Looper.getMainLooper());

    BaseCameraManager() {
    }

    @Override
    public void initializeCameraManager(ConfigurationProvider configurationProvider, Context context) {
        this.context = context;
        this.configurationProvider = configurationProvider;
        this.startBackgroundThread();
    }

    @Override
    public void releaseCameraManager() {
        this.context = null;
        this.stopBackgroundThread();
    }

    protected abstract void prepareCameraOutputs();

    protected abstract boolean prepareVideoRecorder();

    protected abstract void onMaxDurationReached();

    protected abstract void onMaxFileSizeReached();

    protected abstract int getPhotoOrientation(int var1);

    protected abstract int getVideoOrientation(int var1);

    protected void releaseVideoRecorder() {
        try {
            if (this.videoRecorder != null) {
                this.videoRecorder.reset();
                this.videoRecorder.release();
            }
        }
        catch (Exception exception) {
        }
        finally {
            this.videoRecorder = null;
        }
    }

    void startBackgroundThread() {
        this.backgroundThread = new HandlerThread(TAG, 10);
        this.backgroundThread.start();
        this.backgroundHandler = new Handler(this.backgroundThread.getLooper());
    }

    void stopBackgroundThread() {
        if (Build.VERSION.SDK_INT > 17) {
            this.backgroundThread.quitSafely();
        } else {
            this.backgroundThread.quit();
        }
        try {
            this.backgroundThread.join();
        }
        catch (InterruptedException e) {
            Log.e((String)TAG, (String)"stopBackgroundThread: ", (Throwable)e);
        }
        finally {
            this.backgroundThread = null;
            this.backgroundHandler = null;
        }
    }

    public void onInfo(MediaRecorder mediaRecorder, int what, int extra) {
        if (800 == what) {
            this.onMaxDurationReached();
        } else if (801 == what) {
            this.onMaxFileSizeReached();
        }
    }

    @Override
    public boolean isVideoRecording() {
        return this.isVideoRecording;
    }

    @Override
    public CameraId getCurrentCameraId() {
        return this.currentCameraId;
    }

    @Override
    public CameraId getFaceFrontCameraId() {
        return this.faceFrontCameraId;
    }

    @Override
    public CameraId getFaceBackCameraId() {
        return this.faceBackCameraId;
    }

    @Override
    public int getNumberOfCameras() {
        return this.numberOfCameras;
    }

    @Override
    public int getFaceFrontCameraOrientation() {
        return this.faceFrontCameraOrientation;
    }

    @Override
    public int getFaceBackCameraOrientation() {
        return this.faceBackCameraOrientation;
    }
}

