/*
 * Decompiled with CFR 0.152.
 */
package io.github.memfis19.annca.internal.ui.camera2;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.graphics.Matrix;
import android.graphics.RectF;
import android.media.CamcorderProfile;
import android.os.Bundle;
import android.util.Log;
import android.util.Size;
import android.view.TextureView;
import android.view.View;
import io.github.memfis19.annca.internal.controller.impl.Camera2Controller;
import io.github.memfis19.annca.internal.controller.view.CameraView;
import io.github.memfis19.annca.internal.manager.impl.Camera2Manager;
import io.github.memfis19.annca.internal.ui.BaseCameraActivity;
import io.github.memfis19.annca.internal.ui.view.AutoFitTextureView;
import io.github.memfis19.annca.internal.utils.CameraHelper;
import java.util.concurrent.TimeUnit;

@TargetApi(value=21)
public class Camera2Activity
extends BaseCameraActivity
implements CameraView {
    private static final String TAG = "Camera2Activity";
    private AutoFitTextureView autoFitTextureView;
    private Size previewSize;
    private int degrees;
    private CharSequence[] videoQualities;
    private CharSequence[] photoQualities;
    private int cameraFace = 7;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.cameraController = new Camera2Controller(this, this);
        this.cameraController.onCreate(savedInstanceState);
    }

    @Override
    protected void onResume() {
        super.onResume();
        this.controlPanel.lockControls();
        this.controlPanel.allowRecord(false);
        this.cameraController.onResume();
    }

    @Override
    protected void onPause() {
        super.onPause();
        this.controlPanel.lockControls();
        this.controlPanel.allowRecord(false);
        this.cameraController.onPause();
    }

    protected void onDestroy() {
        super.onDestroy();
        this.cameraController.onDestroy();
    }

    @Override
    protected void onTakePhotoEvent() {
        this.cameraController.takePhoto();
    }

    @Override
    protected void onStartRecordingEvent() {
        this.cameraController.startVideoRecord();
    }

    @Override
    protected void onStopRecordingEvent() {
        this.cameraController.stopVideoRecord();
    }

    @Override
    protected void onMediaActionChangedEvent(int mediaActionState) {
    }

    @Override
    protected void onCameraTypeChangedEvent(int cameraType) {
        this.cameraFace = cameraType == 0 ? 6 : 7;
        this.controlPanel.lockControls();
        this.controlPanel.allowRecord(false);
        this.cameraController.switchCamera(this.cameraFace);
    }

    @Override
    public Activity getActivity() {
        return this;
    }

    @Override
    public void updateCameraPreview(Object ... parameters) {
        this.controlPanel.unLockControls();
        this.controlPanel.allowRecord(true);
        this.previewSize = (Size)parameters[0];
        this.autoFitTextureView = new AutoFitTextureView((Context)this, (TextureView.SurfaceTextureListener)parameters[1]);
        this.putPreviewToContainer((View)this.autoFitTextureView);
        this.previewContainer.setAspectRatio((double)this.previewSize.getHeight() / (double)this.previewSize.getWidth());
    }

    @Override
    public void updateUiForMediaAction(int mediaAction) {
    }

    @Override
    public void updateCameraSwitcher(int numberOfCameras) {
        this.controlPanel.allowCameraSwitching(numberOfCameras > 1);
    }

    @Override
    public void onPhotoTaken() {
        this.startPreviewActivity();
    }

    @Override
    public void onVideoRecordStart(int width, int height) {
        this.controlPanel.onStartVideoRecord(this.cameraController.getOutputFile());
    }

    private void configureTransform(int viewWidth, int viewHeight) {
        if (null == this.autoFitTextureView) {
            return;
        }
        Matrix matrix = new Matrix();
        RectF viewRect = new RectF(0.0f, 0.0f, (float)viewWidth, (float)viewHeight);
        RectF bufferRect = new RectF(0.0f, 0.0f, (float)this.previewSize.getWidth(), (float)this.previewSize.getHeight());
        float centerX = viewRect.centerX();
        float centerY = viewRect.centerY();
        bufferRect.offset(centerX - bufferRect.centerX(), centerY - bufferRect.centerY());
        matrix.setRectToRect(viewRect, bufferRect, Matrix.ScaleToFit.FILL);
        float scale = Math.max((float)viewHeight / (float)this.previewSize.getHeight(), (float)viewWidth / (float)this.previewSize.getWidth());
        if (this.cameraFace == 7) {
            matrix.postScale(scale, scale, centerX, centerY);
        } else if (this.degrees == 90 || this.degrees == 270) {
            matrix.postScale(-scale, scale, centerX, centerY);
        } else {
            matrix.postScale(scale, -scale, centerX, centerY);
        }
        int rotation = this.degrees + this.getVideoOrientation(this.getSensorPosition());
        matrix.postRotate((float)Math.abs(this.degrees), centerX, centerY);
        this.autoFitTextureView.setTransform(matrix);
    }

    protected int getVideoOrientation(int sensorPosition) {
        int degrees = 0;
        switch (sensorPosition) {
            case 90: {
                degrees = 0;
                break;
            }
            case 0: {
                degrees = 90;
                break;
            }
            case 270: {
                degrees = 180;
                break;
            }
            case 180: {
                degrees = 270;
            }
        }
        int rotate = this.cameraFace == 6 ? (630 + degrees) % 360 : (450 - degrees) % 360;
        Log.d((String)TAG, (String)("getVideoOrientation: " + String.valueOf(rotate)));
        return rotate;
    }

    @Override
    protected void onScreenRotation(int degrees) {
        super.onScreenRotation(degrees);
        this.degrees = degrees;
    }

    @Override
    public void onVideoRecordStop() {
        this.controlPanel.allowRecord(false);
        this.controlPanel.onStopVideoRecord();
        this.startPreviewActivity();
    }

    @Override
    public void releaseCameraPreview() {
        this.autoFitTextureView = null;
        this.clearPreviewContainer();
    }

    @Override
    public int getMediaAction() {
        return this.currentMediaActionState == 1 ? 100 : 101;
    }

    @Override
    protected CharSequence[] getVideoQualityOptions() {
        this.videoQualities = new CharSequence[]{new VideoQualityOption(10, (String)this.cameraController.getCurrentCameraId(), this.getVideoFileSize(), this.getMinimumVideoDuration()), new VideoQualityOption(13, (String)this.cameraController.getCurrentCameraId(), this.getVideoFileSize(), this.getMinimumVideoDuration()), new VideoQualityOption(12, (String)this.cameraController.getCurrentCameraId(), this.getVideoFileSize(), this.getMinimumVideoDuration()), new VideoQualityOption(11, (String)this.cameraController.getCurrentCameraId(), this.getVideoFileSize(), this.getMinimumVideoDuration())};
        return this.videoQualities;
    }

    @Override
    protected CharSequence[] getPhotoQualityOptions() {
        this.photoQualities = new CharSequence[]{new PhotoQualityOption(14, Camera2Manager.getInstance().getPhotoSizeForQuality(14)), new PhotoQualityOption(13, Camera2Manager.getInstance().getPhotoSizeForQuality(13)), new PhotoQualityOption(12, Camera2Manager.getInstance().getPhotoSizeForQuality(12)), new PhotoQualityOption(15, Camera2Manager.getInstance().getPhotoSizeForQuality(15))};
        return this.photoQualities;
    }

    @Override
    protected int getVideoOptionCheckedIndex() {
        int checkedIndex = -1;
        if (this.mediaQuality == 10) {
            checkedIndex = 0;
        } else if (this.mediaQuality == 13) {
            checkedIndex = 1;
        } else if (this.mediaQuality == 12) {
            checkedIndex = 2;
        } else if (this.mediaQuality == 11) {
            checkedIndex = 3;
        }
        return checkedIndex;
    }

    @Override
    protected int getPhotoOptionCheckedIndex() {
        int checkedIndex = -1;
        if (this.mediaQuality == 14) {
            checkedIndex = 0;
        } else if (this.mediaQuality == 13) {
            checkedIndex = 1;
        } else if (this.mediaQuality == 12) {
            checkedIndex = 2;
        } else if (this.mediaQuality == 15) {
            checkedIndex = 3;
        }
        return checkedIndex;
    }

    @Override
    protected DialogInterface.OnClickListener getVideoOptionSelectedListener() {
        return new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int i) {
                Camera2Activity.this.newQuality = ((VideoQualityOption)Camera2Activity.this.videoQualities[i]).getMediaQuality();
            }
        };
    }

    @Override
    protected DialogInterface.OnClickListener getPhotoOptionSelectedListener() {
        return new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int i) {
                Camera2Activity.this.newQuality = ((PhotoQualityOption)Camera2Activity.this.photoQualities[i]).getMediaQuality();
            }
        };
    }

    private class VideoQualityOption
    implements CharSequence {
        private String title;
        private int mediaQuality;
        private CamcorderProfile camcorderProfile;
        private int videoDuration;

        public VideoQualityOption(int mediaQuality, String cameraId, long maxFileSize, int baseDuration) {
            this.mediaQuality = mediaQuality;
            long minutes = TimeUnit.SECONDS.toMinutes(baseDuration);
            long seconds = (long)baseDuration - minutes * 60L;
            if (mediaQuality == 10) {
                this.title = "Auto , (" + (minutes > 10L ? Long.valueOf(minutes) : "0" + minutes) + ":" + (seconds > 10L ? Long.valueOf(seconds) : "0" + seconds) + " min)";
            } else {
                this.camcorderProfile = CameraHelper.getCamcorderProfile(mediaQuality, cameraId);
                this.videoDuration = (int)CameraHelper.calculateApproximateVideoDuration(this.camcorderProfile, maxFileSize);
                minutes = TimeUnit.SECONDS.toMinutes(this.videoDuration);
                seconds = (long)this.videoDuration - minutes * 60L;
                this.title = String.valueOf(this.camcorderProfile.videoFrameWidth) + " x " + String.valueOf(this.camcorderProfile.videoFrameHeight) + ", (" + (minutes > 10L ? Long.valueOf(minutes) : "0" + minutes) + ":" + (seconds > 10L ? Long.valueOf(seconds) : "0" + seconds) + " min)";
            }
        }

        public int getMediaQuality() {
            return this.mediaQuality;
        }

        @Override
        public int length() {
            return this.title.length();
        }

        @Override
        public char charAt(int i) {
            return this.title.charAt(i);
        }

        @Override
        public CharSequence subSequence(int i, int i1) {
            return this.title.subSequence(i, i1);
        }

        @Override
        public String toString() {
            return this.title;
        }
    }

    private class PhotoQualityOption
    implements CharSequence {
        private int mediaQuality;
        private String title;
        private Size size;

        public PhotoQualityOption(int mediaQuality, Size size) {
            this.mediaQuality = mediaQuality;
            this.size = size;
            this.title = String.valueOf(size.getWidth()) + " x " + String.valueOf(size.getHeight());
        }

        public int getMediaQuality() {
            return this.mediaQuality;
        }

        @Override
        public int length() {
            return this.title.length();
        }

        @Override
        public char charAt(int i) {
            return this.title.charAt(i);
        }

        @Override
        public CharSequence subSequence(int i, int i1) {
            return this.title.subSequence(i, i1);
        }

        @Override
        public String toString() {
            return this.title;
        }
    }
}

