/*
 * Decompiled with CFR 0.152.
 */
package io.github.memfis19.annca.internal.ui;

import android.content.Context;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v7.app.AppCompatActivity;
import io.github.memfis19.annca.internal.configuration.ConfigurationProvider;
import io.github.memfis19.annca.internal.utils.Utils;

public abstract class CameraActivity
extends AppCompatActivity
implements ConfigurationProvider,
SensorEventListener {
    protected static final int REQUEST_PREVIEW_CODE = 1001;
    public static final int ACTION_CONFIRM = 900;
    public static final int ACTION_RETAKE = 901;
    public static final int ACTION_CANCEL = 902;
    private SensorManager sensorManager = null;
    protected int requestCode = -1;
    protected int mediaAction = 102;
    protected int mediaQuality = 12;
    protected int videoDuration = -1;
    protected long videoFileSize = -1L;
    private int degrees = -1;
    protected int sensorPosition = -1;
    protected int deviceDefaultOrientation;

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.sensorManager = (SensorManager)this.getSystemService("sensor");
        int defaultOrientation = Utils.getDeviceDefaultOrientation((Context)this);
        if (defaultOrientation == 2) {
            this.deviceDefaultOrientation = 546;
        } else if (defaultOrientation == 1) {
            this.deviceDefaultOrientation = 273;
        }
        this.extractConfiguration(savedInstanceState != null ? savedInstanceState : this.getIntent().getExtras());
    }

    private void extractConfiguration(Bundle bundle) {
        if (bundle != null) {
            if (bundle.containsKey("io.memfis19.annca.request_code")) {
                this.requestCode = bundle.getInt("io.memfis19.annca.request_code");
            }
            if (bundle.containsKey("io.memfis19.annca.media_action")) {
                this.mediaAction = bundle.getInt("io.memfis19.annca.media_action");
            }
            if (bundle.containsKey("io.memfis19.annca.camera_media_quality")) {
                this.mediaQuality = bundle.getInt("io.memfis19.annca.camera_media_quality");
            }
            if (bundle.containsKey("io.memfis19.annca.video_duration")) {
                this.videoDuration = bundle.getInt("io.memfis19.annca.video_duration");
            }
            if (bundle.containsKey("io.memfis19.annca.camera_video_file_size")) {
                this.videoFileSize = bundle.getLong("io.memfis19.annca.camera_video_file_size");
            }
        }
    }

    protected void onResume() {
        super.onResume();
        this.sensorManager.registerListener((SensorEventListener)this, this.sensorManager.getDefaultSensor(1), 3);
    }

    protected void onPause() {
        super.onPause();
        this.sensorManager.unregisterListener((SensorEventListener)this);
    }

    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putInt("io.memfis19.annca.request_code", this.requestCode);
        outState.putInt("io.memfis19.annca.media_action", this.requestCode);
        outState.putInt("io.memfis19.annca.camera_media_quality", this.requestCode);
        outState.putInt("io.memfis19.annca.video_duration", this.requestCode);
        outState.putLong("io.memfis19.annca.camera_video_file_size", (long)this.requestCode);
    }

    protected abstract void onTakePhotoEvent();

    protected abstract void onStartRecordingEvent();

    protected abstract void onStopRecordingEvent();

    protected abstract void onMediaActionChangedEvent(int var1);

    protected abstract void onCameraTypeChangedEvent(int var1);

    protected abstract void onScreenRotation(int var1);

    protected abstract void onSettingsEvent();

    @Override
    public int getRequestCode() {
        return this.requestCode;
    }

    @Override
    public int getMediaAction() {
        return this.mediaAction;
    }

    @Override
    public int getMediaQuality() {
        return this.mediaQuality;
    }

    @Override
    public int getVideoDuration() {
        return this.videoDuration;
    }

    @Override
    public long getVideoFileSize() {
        return this.videoFileSize;
    }

    @Override
    public int getSensorPosition() {
        return this.sensorPosition;
    }

    @Override
    public int getDegrees() {
        return this.degrees;
    }

    @Override
    public int getMinimumVideoDuration() {
        return 300;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSensorChanged(SensorEvent sensorEvent) {
        CameraActivity cameraActivity = this;
        synchronized (cameraActivity) {
            if (sensorEvent.sensor.getType() == 1) {
                if (sensorEvent.values[0] < 4.0f && sensorEvent.values[0] > -4.0f) {
                    if (sensorEvent.values[1] > 0.0f) {
                        this.sensorPosition = 90;
                        this.degrees = this.deviceDefaultOrientation == 273 ? 0 : 90;
                    } else if (sensorEvent.values[1] < 0.0f) {
                        this.sensorPosition = 270;
                        this.degrees = this.deviceDefaultOrientation == 273 ? 180 : 270;
                    }
                } else if (sensorEvent.values[1] < 4.0f && sensorEvent.values[1] > -4.0f) {
                    if (sensorEvent.values[0] > 0.0f) {
                        this.sensorPosition = 0;
                        this.degrees = this.deviceDefaultOrientation == 273 ? 90 : 180;
                    } else if (sensorEvent.values[0] < 0.0f) {
                        this.sensorPosition = 180;
                        this.degrees = this.deviceDefaultOrientation == 273 ? 270 : 0;
                    }
                }
                this.onScreenRotation(this.degrees);
            }
        }
    }

    public void onAccuracyChanged(Sensor sensor, int accuracy) {
    }
}

