/*
 * Decompiled with CFR 0.152.
 */
package io.github.memfis19.annca.internal.ui;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import io.github.memfis19.annca.R;
import io.github.memfis19.annca.internal.controller.CameraController;
import io.github.memfis19.annca.internal.ui.CameraActivity;
import io.github.memfis19.annca.internal.ui.preview.PreviewActivity;
import io.github.memfis19.annca.internal.ui.view.AspectFrameLayout;
import io.github.memfis19.annca.internal.ui.view.CameraControlPanel;
import io.github.memfis19.annca.internal.ui.view.CameraSwitchView;
import io.github.memfis19.annca.internal.ui.view.FlashSwitchView;
import io.github.memfis19.annca.internal.ui.view.MediaActionSwitchView;
import io.github.memfis19.annca.internal.ui.view.RecordButton;
import io.github.memfis19.annca.internal.utils.Utils;

public abstract class BaseCameraActivity
extends CameraActivity
implements RecordButton.RecordButtonListener,
FlashSwitchView.FlashModeSwitchListener,
MediaActionSwitchView.OnMediaActionStateChangeListener,
CameraSwitchView.OnCameraTypeChangeListener,
CameraControlPanel.SettingsClickListener {
    protected CameraController cameraController;
    protected AspectFrameLayout previewContainer;
    protected CameraControlPanel controlPanel;
    private AlertDialog settingsDialog;
    protected int currentMediaActionState;
    protected int currentCameraType = 1;
    protected int newQuality = -1;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.currentMediaActionState = this.mediaAction == 100 ? 1 : 0;
        View decorView = this.getWindow().getDecorView();
        if (Build.VERSION.SDK_INT > 15) {
            int uiOptions = 1024;
            decorView.setSystemUiVisibility(uiOptions);
        }
        this.setContentView(R.layout.base_camera_layout);
        this.previewContainer = (AspectFrameLayout)this.findViewById(R.id.previewContainer);
        this.controlPanel = (CameraControlPanel)this.findViewById(R.id.controlPanel);
        if (this.controlPanel != null) {
            this.controlPanel.setup(this.getMediaAction());
            this.controlPanel.setRecordButtonListener(this);
            this.controlPanel.setFlashModeSwitchListener(this);
            this.controlPanel.setOnMediaActionStateChangeListener(this);
            this.controlPanel.setOnCameraTypeChangeListener(this);
            this.controlPanel.setMaxVideoDuration(this.getVideoDuration());
            this.controlPanel.setMaxVideoFileSize(this.getVideoFileSize());
            this.controlPanel.setSettingsClickListener(this);
        }
    }

    protected final void putPreviewToContainer(View child) {
        if (this.previewContainer == null || child == null) {
            return;
        }
        this.previewContainer.removeAllViews();
        this.previewContainer.addView(child);
    }

    protected final void clearPreviewContainer() {
        if (this.previewContainer != null) {
            this.previewContainer.removeAllViews();
        }
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (resultCode == -1 && requestCode == 1001) {
            if (PreviewActivity.isResultConfirm(data)) {
                Intent resultIntent = new Intent();
                resultIntent.putExtra("io.memfis19.annca.camera_video_file_path", PreviewActivity.getMediaFilePatch(data));
                this.setResult(-1, resultIntent);
                this.finish();
            } else if (PreviewActivity.isResultCancel(data)) {
                this.setResult(0);
                this.finish();
            } else if (PreviewActivity.isResultRetake(data)) {
                // empty if block
            }
        }
    }

    @Override
    public void onTakePhotoButtonPressed() {
        this.onTakePhotoEvent();
    }

    @Override
    public void onStartRecordingButtonPressed() {
        this.onStartRecordingEvent();
    }

    @Override
    public void onStopRecordingButtonPressed() {
        this.onStopRecordingEvent();
    }

    @Override
    public void onFlashModeChanged(FlashSwitchView.FlashMode mode) {
    }

    @Override
    public void onMediaActionChanged(int actionState) {
        if (this.currentMediaActionState == actionState) {
            return;
        }
        this.currentMediaActionState = actionState;
        this.onMediaActionChangedEvent(this.currentMediaActionState);
    }

    @Override
    public void onCameraTypeChanged(int cameraType) {
        if (this.currentCameraType == cameraType) {
            return;
        }
        this.currentCameraType = cameraType;
        this.onCameraTypeChangedEvent(cameraType);
    }

    protected void startPreviewActivity() {
        Intent intent = PreviewActivity.newIntent((Context)this, this.getMediaAction(), this.cameraController.getOutputFile().toString());
        this.startActivityForResult(intent, 1001);
    }

    @Override
    protected void onScreenRotation(int degrees) {
        this.controlPanel.rotateControls(degrees);
        this.rotateSettingsDialog(degrees);
    }

    @Override
    public void onSettingsClick() {
        this.onSettingsEvent();
    }

    @Override
    protected void onSettingsEvent() {
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)this);
        if (this.getMediaAction() == 100) {
            builder.setSingleChoiceItems(this.getVideoQualityOptions(), this.getVideoOptionCheckedIndex(), this.getVideoOptionSelectedListener());
            if (this.getVideoFileSize() > 0L) {
                builder.setTitle((CharSequence)String.format(this.getString(R.string.settings_video_quality_title), "(Max " + String.valueOf(this.getVideoFileSize() / 0x100000L + " MB)")));
            } else {
                builder.setTitle((CharSequence)String.format(this.getString(R.string.settings_video_quality_title), ""));
            }
        } else {
            builder.setSingleChoiceItems(this.getPhotoQualityOptions(), this.getPhotoOptionCheckedIndex(), this.getPhotoOptionSelectedListener());
            builder.setTitle(R.string.settings_photo_quality_title);
        }
        builder.setPositiveButton(R.string.ok_label, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int i) {
                if (BaseCameraActivity.this.newQuality > 0 && BaseCameraActivity.this.newQuality != BaseCameraActivity.this.mediaQuality) {
                    BaseCameraActivity.this.mediaQuality = BaseCameraActivity.this.newQuality;
                    dialogInterface.dismiss();
                    BaseCameraActivity.this.controlPanel.lockControls();
                    BaseCameraActivity.this.cameraController.switchQuality();
                }
            }
        });
        builder.setNegativeButton(R.string.cancel_label, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int i) {
                dialogInterface.dismiss();
            }
        });
        this.settingsDialog = builder.create();
        this.settingsDialog.show();
        WindowManager.LayoutParams lp = new WindowManager.LayoutParams();
        lp.copyFrom(this.settingsDialog.getWindow().getAttributes());
        lp.width = Utils.convertDipToPixels((Context)this, 350);
        lp.height = Utils.convertDipToPixels((Context)this, 350);
        this.settingsDialog.getWindow().setAttributes(lp);
    }

    private void rotateSettingsDialog(int degrees) {
        if (this.settingsDialog != null && this.settingsDialog.isShowing() && Build.VERSION.SDK_INT > 10) {
            ViewGroup dialogView = (ViewGroup)this.settingsDialog.getWindow().getDecorView();
            for (int i = 0; i < dialogView.getChildCount(); ++i) {
                dialogView.getChildAt(i).setRotation((float)degrees);
            }
        }
    }

    protected abstract CharSequence[] getVideoQualityOptions();

    protected abstract CharSequence[] getPhotoQualityOptions();

    protected abstract int getVideoOptionCheckedIndex();

    protected abstract int getPhotoOptionCheckedIndex();

    protected abstract DialogInterface.OnClickListener getVideoOptionSelectedListener();

    protected abstract DialogInterface.OnClickListener getPhotoOptionSelectedListener();
}

