/*
 * Decompiled with CFR 0.152.
 */
package io.github.memfis19.annca.internal.controller.impl;

import android.content.Context;
import android.hardware.Camera;
import android.os.Bundle;
import android.view.SurfaceHolder;
import io.github.memfis19.annca.internal.configuration.ConfigurationProvider;
import io.github.memfis19.annca.internal.controller.CameraController;
import io.github.memfis19.annca.internal.controller.view.CameraView;
import io.github.memfis19.annca.internal.manager.CameraManager;
import io.github.memfis19.annca.internal.manager.impl.Camera1Manager;
import io.github.memfis19.annca.internal.manager.listener.CameraCloseListener;
import io.github.memfis19.annca.internal.manager.listener.CameraOpenListener;
import io.github.memfis19.annca.internal.manager.listener.CameraPhotoListener;
import io.github.memfis19.annca.internal.manager.listener.CameraVideoListener;
import io.github.memfis19.annca.internal.utils.CameraHelper;
import java.io.File;

public class Camera1Controller
implements CameraController<Integer>,
CameraOpenListener<Integer, Camera.Size, SurfaceHolder.Callback>,
CameraPhotoListener,
CameraCloseListener<Integer>,
CameraVideoListener<Camera.Size> {
    private static final String TAG = "Camera1Controller";
    private CameraView cameraView;
    private ConfigurationProvider configurationProvider;
    private CameraManager<Integer, Camera.Size, SurfaceHolder.Callback> cameraManager;
    private File outputFile;
    private Integer currentCameraId;

    public Camera1Controller(CameraView cameraView, ConfigurationProvider configurationProvider) {
        this.cameraView = cameraView;
        this.configurationProvider = configurationProvider;
    }

    @Override
    public void onCreate(Bundle savedInstanceState) {
        this.cameraManager = Camera1Manager.getInstance();
        this.cameraManager.initializeCameraManager(this.configurationProvider, (Context)this.cameraView.getActivity());
        this.currentCameraId = this.cameraManager.getFaceBackCameraId();
    }

    @Override
    public void onResume() {
        this.cameraManager.openCamera(this.currentCameraId, this);
    }

    @Override
    public void onPause() {
        this.cameraManager.closeCamera(null);
    }

    @Override
    public void onDestroy() {
        this.cameraManager.releaseCameraManager();
    }

    @Override
    public void takePhoto() {
        this.outputFile = CameraHelper.getOutputMediaFile((Context)this.cameraView.getActivity(), 101);
        this.cameraManager.takePhoto(this.outputFile, this);
    }

    @Override
    public void startVideoRecord() {
        this.outputFile = CameraHelper.getOutputMediaFile((Context)this.cameraView.getActivity(), 100);
        this.cameraManager.startVideoRecord(this.outputFile, this);
    }

    @Override
    public void stopVideoRecord() {
        this.cameraManager.stopVideoRecord();
    }

    @Override
    public boolean isVideoRecording() {
        return this.cameraManager.isVideoRecording();
    }

    @Override
    public void switchCamera(int cameraFace) {
        this.currentCameraId = this.cameraManager.getCurrentCameraId().equals(this.cameraManager.getFaceFrontCameraId()) ? this.cameraManager.getFaceBackCameraId() : this.cameraManager.getFaceFrontCameraId();
        this.cameraManager.closeCamera(this);
    }

    @Override
    public void switchQuality() {
        this.cameraManager.closeCamera(this);
    }

    @Override
    public int getNumberOfCameras() {
        return this.cameraManager.getNumberOfCameras();
    }

    @Override
    public int getMediaAction() {
        return this.configurationProvider.getMediaAction();
    }

    @Override
    public int getCameraOrientation() {
        return 0;
    }

    @Override
    public File getOutputFile() {
        return this.outputFile;
    }

    @Override
    public Integer getCurrentCameraId() {
        return this.currentCameraId;
    }

    @Override
    public void onCameraOpened(Integer cameraId, Camera.Size previewSize, SurfaceHolder.Callback surfaceCallback) {
        this.cameraView.updateCameraSwitcher(this.getNumberOfCameras());
        this.cameraView.updateUiForMediaAction(this.configurationProvider.getMediaAction());
        this.cameraView.updateCameraPreview(previewSize, surfaceCallback);
    }

    @Override
    public void onCameraOpenError() {
    }

    @Override
    public void onPhotoTaken(File photoFile) {
        this.cameraView.onPhotoTaken();
    }

    @Override
    public void onPhotoTakeError() {
    }

    @Override
    public void onCameraClosed(Integer closedCameraId) {
        this.cameraView.releaseCameraPreview();
        this.cameraManager.openCamera(this.currentCameraId, this);
    }

    @Override
    public void onVideoRecordStarted(Camera.Size videoSize) {
        this.cameraView.onVideoRecordStart(videoSize.width, videoSize.height);
    }

    @Override
    public void onVideoRecordStopped(File videoFile) {
        this.cameraView.onVideoRecordStop();
    }

    @Override
    public void onVideoRecordError() {
    }
}

