/*
 * Decompiled with CFR 0.152.
 */
package com.sankuai.waimai.router.utils;

import android.net.Uri;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.sankuai.waimai.router.core.Debugger;
import java.util.Map;

public class RouterUtils {
    public static String toLowerCase(String s) {
        return TextUtils.isEmpty((CharSequence)s) ? s : s.toLowerCase();
    }

    public static String toNonNullString(String s) {
        return s == null ? "" : s;
    }

    public static boolean isEmpty(Object[] objects) {
        return objects == null || objects.length == 0;
    }

    @NonNull
    public static String schemeHost(String scheme, String host) {
        return RouterUtils.toNonNullString(RouterUtils.toLowerCase(scheme)) + "://" + RouterUtils.toNonNullString(RouterUtils.toLowerCase(host));
    }

    public static String schemeHost(Uri uri) {
        return uri == null ? null : RouterUtils.schemeHost(uri.getScheme(), uri.getHost());
    }

    public static Uri appendParams(Uri uri, Map<String, String> params) {
        if (uri != null && params != null && !params.isEmpty()) {
            Uri.Builder builder = uri.buildUpon();
            try {
                for (String key : params.keySet()) {
                    String val;
                    if (TextUtils.isEmpty((CharSequence)key) || (val = uri.getQueryParameter(key)) != null) continue;
                    String value = params.get(key);
                    builder.appendQueryParameter(key, value);
                }
                return builder.build();
            }
            catch (Exception e) {
                Debugger.fatal(e);
            }
        }
        return uri;
    }

    public static String appendSlash(String path) {
        if (path != null && !path.startsWith("/")) {
            path = '/' + path;
        }
        return path;
    }
}

