/*
 * Decompiled with CFR 0.152.
 */
package com.sankuai.waimai.router.utils;

import androidx.annotation.NonNull;
import com.sankuai.waimai.router.annotation.RouterProvider;
import com.sankuai.waimai.router.core.Debugger;
import com.sankuai.waimai.router.utils.RouterUtils;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;

public class ProviderPool {
    private static final HashMap<Class, Method> CACHE = new HashMap();
    private static final Method NOT_FOUND = Object.class.getDeclaredMethods()[0];

    public static <T> T create(Class<T> clazz) {
        if (clazz == null) {
            return null;
        }
        Method provider = ProviderPool.getProvider(clazz);
        if (provider == NOT_FOUND) {
            Debugger.i("[ProviderPool] provider not found: %s", clazz);
            return null;
        }
        Debugger.i("[ProviderPool] provider found: %s", provider);
        try {
            return (T)provider.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            Debugger.fatal(e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    private static <T> Method getProvider(@NonNull Class<T> clazz) {
        Method provider = CACHE.get(clazz);
        if (provider == null) {
            HashMap<Class, Method> hashMap = CACHE;
            synchronized (hashMap) {
                provider = CACHE.get(clazz);
                if (provider == null) {
                    provider = ProviderPool.findProvider(clazz);
                    CACHE.put(clazz, provider);
                }
            }
        }
        return provider;
    }

    @NonNull
    private static Method findProvider(@NonNull Class clazz) {
        Debugger.i("[ProviderPool] >>> find provider with reflection: %s", clazz);
        for (Method method : clazz.getDeclaredMethods()) {
            if (method.getAnnotation(RouterProvider.class) == null) continue;
            if (Modifier.isStatic(method.getModifiers()) && method.getReturnType() == clazz && RouterUtils.isEmpty(method.getParameterTypes())) {
                return method;
            }
            Debugger.fatal("[ProviderPool] RouterProvider\u6ce8\u89e3\u7684\u5e94\u8be5\u662f\u9759\u6001\u65e0\u53c2\u6570\u65b9\u6cd5\uff0c\u4e14\u8fd4\u56de\u503c\u7c7b\u578b\u4e3a\u5f53\u524dClass", new Object[0]);
            return NOT_FOUND;
        }
        return NOT_FOUND;
    }
}

