/*
 * Decompiled with CFR 0.152.
 */
package com.sankuai.waimai.router.utils;

import android.annotation.TargetApi;
import androidx.annotation.NonNull;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.function.Consumer;

public class PriorityList<T>
extends AbstractList<T> {
    private final LinkedList<Node<T>> mList = new LinkedList();
    private final int mDefaultPriority;

    public PriorityList(int defaultPriority) {
        this.mDefaultPriority = defaultPriority;
    }

    public PriorityList() {
        this(0);
    }

    public boolean addItem(T item, int priority) {
        Node<T> node = new Node<T>(item, priority);
        if (this.mList.isEmpty()) {
            this.mList.add(node);
            return true;
        }
        ListIterator<Node<T>> iterator = this.mList.listIterator();
        while (iterator.hasNext()) {
            Node next = (Node)iterator.next();
            if (next.priority >= priority) continue;
            iterator.previous();
            iterator.add(node);
            return true;
        }
        this.mList.addLast(node);
        return true;
    }

    @Override
    @Deprecated
    public void add(int index, T element) {
        throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u6dfb\u52a0\u5230\u6307\u5b9a\u4f4d\u7f6e");
    }

    public boolean addItem(T item) {
        return this.addItem(item, this.mDefaultPriority);
    }

    @Override
    public boolean add(T item) {
        return this.addItem(item, this.mDefaultPriority);
    }

    @Override
    public boolean remove(Object item) {
        Iterator iterator = this.mList.iterator();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            if (node.data != item) continue;
            iterator.remove();
            return true;
        }
        return false;
    }

    @Override
    public int size() {
        return this.mList.size();
    }

    @Override
    public T get(int index) {
        return this.mList.get((int)index).data;
    }

    public int getPriory(int index) {
        return this.mList.get((int)index).priority;
    }

    @Override
    public T set(int index, T element) {
        Node<T> node = this.mList.get(index);
        Object t = node.data;
        node.data = element;
        return t;
    }

    @Override
    @NonNull
    public Iterator<T> iterator() {
        return new NodeIterator();
    }

    private class NodeIterator
    implements Iterator<T> {
        private final ListIterator<Node<T>> mIterator;

        public NodeIterator() {
            this(0);
        }

        public NodeIterator(int index) {
            this.mIterator = PriorityList.this.mList.listIterator(index);
        }

        @Override
        public boolean hasNext() {
            return this.mIterator.hasNext();
        }

        @Override
        public T next() {
            return this.mIterator.next().data;
        }

        @Override
        public void remove() {
            this.mIterator.remove();
        }

        @Override
        @TargetApi(value=24)
        public void forEachRemaining(final Consumer<? super T> action) {
            this.mIterator.forEachRemaining(new Consumer<Node<T>>(){

                @Override
                public void accept(Node<T> node) {
                    action.accept(node.data);
                }
            });
        }
    }

    private static class Node<T> {
        int priority;
        T data;

        Node(T data, int priority) {
            this.data = data;
            this.priority = priority;
        }
    }
}

