/*
 * Decompiled with CFR 0.152.
 */
package com.sankuai.waimai.router.service;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.sankuai.waimai.router.components.RouterComponents;
import com.sankuai.waimai.router.core.Debugger;
import com.sankuai.waimai.router.service.ContextFactory;
import com.sankuai.waimai.router.service.IFactory;
import com.sankuai.waimai.router.service.ServiceImpl;
import com.sankuai.waimai.router.utils.LazyInitHelper;
import com.sankuai.waimai.router.utils.SingletonPool;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ServiceLoader<I> {
    private static final Map<Class, ServiceLoader> SERVICES = new HashMap<Class, ServiceLoader>();
    private static final LazyInitHelper sInitHelper = new LazyInitHelper("ServiceLoader"){

        @Override
        protected void doInit() {
            try {
                Class.forName("com.sankuai.waimai.router.generated.ServiceLoaderInit").getMethod("init", new Class[0]).invoke(null, new Object[0]);
                Debugger.i("[ServiceLoader] init class invoked", new Object[0]);
            }
            catch (Exception e) {
                Debugger.fatal(e);
            }
        }
    };
    private HashMap<String, ServiceImpl> mMap = new HashMap();
    private final String mInterfaceName;

    public static void lazyInit() {
        sInitHelper.lazyInit();
    }

    public static void put(Class interfaceClass, String key, Class implementClass, boolean singleton) {
        ServiceLoader loader = SERVICES.get(interfaceClass);
        if (loader == null) {
            loader = new ServiceLoader(interfaceClass);
            SERVICES.put(interfaceClass, loader);
        }
        super.putImpl(key, implementClass, singleton);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> ServiceLoader<T> load(Class<T> interfaceClass) {
        sInitHelper.ensureInit();
        if (interfaceClass == null) {
            Debugger.fatal(new NullPointerException("ServiceLoader.load\u7684class\u53c2\u6570\u4e0d\u5e94\u4e3a\u7a7a"));
            return EmptyServiceLoader.INSTANCE;
        }
        ServiceLoader service = SERVICES.get(interfaceClass);
        if (service == null) {
            Map<Class, ServiceLoader> map = SERVICES;
            synchronized (map) {
                service = SERVICES.get(interfaceClass);
                if (service == null) {
                    service = new ServiceLoader(interfaceClass);
                    SERVICES.put(interfaceClass, service);
                }
            }
        }
        return service;
    }

    private ServiceLoader(Class interfaceClass) {
        this.mInterfaceName = interfaceClass == null ? "" : interfaceClass.getName();
    }

    private void putImpl(String key, Class implementClass, boolean singleton) {
        if (key != null && implementClass != null) {
            this.mMap.put(key, new ServiceImpl(key, implementClass, singleton));
        }
    }

    public <T extends I> T get(String key) {
        return this.createInstance(this.mMap.get(key), null);
    }

    public <T extends I> T get(String key, Context context) {
        return this.createInstance(this.mMap.get(key), new ContextFactory(context));
    }

    public <T extends I> T get(String key, IFactory factory) {
        return this.createInstance(this.mMap.get(key), factory);
    }

    @NonNull
    public <T extends I> List<T> getAll() {
        return this.getAll((IFactory)null);
    }

    @NonNull
    public <T extends I> List<T> getAll(Context context) {
        return this.getAll(new ContextFactory(context));
    }

    @NonNull
    public <T extends I> List<T> getAll(IFactory factory) {
        Collection<ServiceImpl> services = this.mMap.values();
        if (services.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<T> list = new ArrayList<T>(services.size());
        for (ServiceImpl impl : services) {
            T instance = this.createInstance(impl, factory);
            if (instance == null) continue;
            list.add(instance);
        }
        return list;
    }

    public <T extends I> Class<T> getClass(String key) {
        return this.mMap.get(key).getImplementationClazz();
    }

    @NonNull
    public <T extends I> List<Class<T>> getAllClasses() {
        ArrayList<Class<T>> list = new ArrayList<Class<T>>(this.mMap.size());
        for (ServiceImpl impl : this.mMap.values()) {
            Class clazz = impl.getImplementationClazz();
            if (clazz == null) continue;
            list.add(clazz);
        }
        return list;
    }

    @Nullable
    private <T extends I> T createInstance(@Nullable ServiceImpl impl, @Nullable IFactory factory) {
        if (impl == null) {
            return null;
        }
        Class clazz = impl.getImplementationClazz();
        if (impl.isSingleton()) {
            try {
                return SingletonPool.get(clazz, factory);
            }
            catch (Exception e) {
                Debugger.fatal(e);
            }
        } else {
            try {
                if (factory == null) {
                    factory = RouterComponents.getDefaultFactory();
                }
                Object t = factory.create(clazz);
                Debugger.i("[ServiceLoader] create instance: %s, result = %s", clazz, t);
                return t;
            }
            catch (Exception e) {
                Debugger.fatal(e);
            }
        }
        return null;
    }

    public String toString() {
        return "ServiceLoader (" + this.mInterfaceName + ")";
    }

    public static class EmptyServiceLoader
    extends ServiceLoader {
        public static final ServiceLoader INSTANCE = new EmptyServiceLoader();

        public EmptyServiceLoader() {
            super(null);
        }

        @NonNull
        public List<Class> getAllClasses() {
            return Collections.emptyList();
        }

        @NonNull
        public List getAll() {
            return Collections.emptyList();
        }

        @NonNull
        public List getAll(IFactory factory) {
            return Collections.emptyList();
        }

        @Override
        public String toString() {
            return "EmptyServiceLoader";
        }
    }
}

