/*
 * Decompiled with CFR 0.152.
 */
package com.sankuai.waimai.router.core;

import android.content.Context;
import android.net.Uri;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.sankuai.waimai.router.Router;
import com.sankuai.waimai.router.core.Debugger;
import com.sankuai.waimai.router.core.OnCompleteListener;
import com.sankuai.waimai.router.utils.RouterUtils;
import java.util.HashMap;
import java.util.Map;

public class UriRequest {
    public static final String FIELD_COMPLETE_LISTENER = "com.sankuai.waimai.router.core.CompleteListener";
    public static final String FIELD_RESULT_CODE = "com.sankuai.waimai.router.core.result";
    public static final String FIELD_ERROR_MSG = "com.sankuai.waimai.router.core.error.msg";
    @NonNull
    private final Context mContext;
    @NonNull
    private Uri mUri;
    @NonNull
    private final HashMap<String, Object> mFields;
    private boolean isSkipInterceptors = false;
    private String mSchemeHost = null;

    public UriRequest(@NonNull Context context, String uri) {
        this(context, UriRequest.parseUriSafely(uri), new HashMap<String, Object>());
    }

    public UriRequest(@NonNull Context context, Uri uri) {
        this(context, uri, new HashMap<String, Object>());
    }

    public UriRequest(@NonNull Context context, String uri, HashMap<String, Object> fields) {
        this(context, UriRequest.parseUriSafely(uri), fields);
    }

    public UriRequest(@NonNull Context context, Uri uri, HashMap<String, Object> fields) {
        this.mContext = context;
        this.mUri = uri == null ? Uri.EMPTY : uri;
        this.mFields = fields == null ? new HashMap() : fields;
    }

    @NonNull
    public HashMap<String, Object> getFields() {
        return this.mFields;
    }

    private static Uri parseUriSafely(@Nullable String uri) {
        return TextUtils.isEmpty((CharSequence)uri) ? Uri.EMPTY : Uri.parse((String)uri);
    }

    public UriRequest onComplete(OnCompleteListener listener) {
        this.putField(FIELD_COMPLETE_LISTENER, listener);
        return this;
    }

    public UriRequest setResultCode(int resultCode) {
        this.putField(FIELD_RESULT_CODE, resultCode);
        return this;
    }

    public UriRequest setErrorMessage(String message) {
        this.putField(FIELD_ERROR_MSG, message);
        return this;
    }

    public OnCompleteListener getOnCompleteListener() {
        return this.getField(OnCompleteListener.class, FIELD_COMPLETE_LISTENER);
    }

    public int getResultCode() {
        return this.getIntField(FIELD_RESULT_CODE, 500);
    }

    public String getErrorMessage() {
        return this.getStringField(FIELD_ERROR_MSG, "");
    }

    public String schemeHost() {
        if (this.mSchemeHost == null) {
            this.mSchemeHost = RouterUtils.schemeHost(this.getUri());
        }
        return this.mSchemeHost;
    }

    public boolean isUriEmpty() {
        return Uri.EMPTY.equals((Object)this.mUri);
    }

    @NonNull
    public Context getContext() {
        return this.mContext;
    }

    @NonNull
    public Uri getUri() {
        return this.mUri;
    }

    public void setUri(@NonNull Uri uri) {
        if (uri != null && !Uri.EMPTY.equals((Object)uri)) {
            this.mUri = uri;
            this.mSchemeHost = null;
        } else {
            Debugger.fatal("UriRequest.setUri\u4e0d\u5e94\u8be5\u4f20\u5165\u7a7a\u503c", new Object[0]);
        }
    }

    public UriRequest skipInterceptors() {
        this.isSkipInterceptors = true;
        return this;
    }

    public boolean isSkipInterceptors() {
        return this.isSkipInterceptors;
    }

    public <T> UriRequest putField(@NonNull String key, T val) {
        if (val != null) {
            this.mFields.put(key, val);
        }
        return this;
    }

    public synchronized <T> UriRequest putFieldIfAbsent(@NonNull String key, T val) {
        if (val != null && !this.mFields.containsKey(key)) {
            this.mFields.put(key, val);
        }
        return this;
    }

    public UriRequest putFields(HashMap<String, Object> fields) {
        if (fields != null) {
            this.mFields.putAll(fields);
        }
        return this;
    }

    public boolean hasField(@NonNull String key) {
        return this.mFields.containsKey(key);
    }

    public int getIntField(@NonNull String key, int defaultValue) {
        return this.getField(Integer.class, key, defaultValue);
    }

    public long getLongField(@NonNull String key, long defaultValue) {
        return this.getField(Long.class, key, defaultValue);
    }

    public boolean getBooleanField(@NonNull String key, boolean defaultValue) {
        return this.getField(Boolean.class, key, defaultValue);
    }

    public String getStringField(@NonNull String key) {
        return this.getField(String.class, key, null);
    }

    public String getStringField(@NonNull String key, String defaultValue) {
        return this.getField(String.class, key, defaultValue);
    }

    public <T> T getField(@NonNull Class<T> clazz, @NonNull String key) {
        return this.getField(clazz, key, null);
    }

    public <T> T getField(@NonNull Class<T> clazz, @NonNull String key, T defaultValue) {
        Object field = this.mFields.get(key);
        if (field != null) {
            try {
                return clazz.cast(field);
            }
            catch (ClassCastException e) {
                Debugger.fatal(e);
            }
        }
        return defaultValue;
    }

    public void start() {
        Router.startUri(this);
    }

    public String toString() {
        return this.mUri.toString();
    }

    public String toFullString() {
        StringBuilder s = new StringBuilder(this.mUri.toString());
        s.append(", fields = {");
        boolean first = true;
        for (Map.Entry<String, Object> entry : this.mFields.entrySet()) {
            if (first) {
                first = false;
            } else {
                s.append(", ");
            }
            s.append(entry.getKey()).append(" = ").append(entry.getValue());
        }
        s.append("}");
        return s.toString();
    }
}

