/*
 * Decompiled with CFR 0.152.
 */
package com.sankuai.waimai.router.core;

import androidx.annotation.NonNull;
import com.sankuai.waimai.router.core.ChainedInterceptor;
import com.sankuai.waimai.router.core.Debugger;
import com.sankuai.waimai.router.core.UriCallback;
import com.sankuai.waimai.router.core.UriInterceptor;
import com.sankuai.waimai.router.core.UriRequest;

public abstract class UriHandler {
    protected ChainedInterceptor mInterceptor;

    public UriHandler addInterceptor(@NonNull UriInterceptor interceptor) {
        if (interceptor != null) {
            if (this.mInterceptor == null) {
                this.mInterceptor = new ChainedInterceptor();
            }
            this.mInterceptor.addInterceptor(interceptor);
        }
        return this;
    }

    public UriHandler addInterceptors(UriInterceptor ... interceptors) {
        if (interceptors != null && interceptors.length > 0) {
            if (this.mInterceptor == null) {
                this.mInterceptor = new ChainedInterceptor();
            }
            for (UriInterceptor interceptor : interceptors) {
                this.mInterceptor.addInterceptor(interceptor);
            }
        }
        return this;
    }

    public void handle(final @NonNull UriRequest request, final @NonNull UriCallback callback) {
        if (this.shouldHandle(request)) {
            Debugger.i("%s: handle request %s", this, request);
            if (this.mInterceptor != null && !request.isSkipInterceptors()) {
                this.mInterceptor.intercept(request, new UriCallback(){

                    @Override
                    public void onNext() {
                        UriHandler.this.handleInternal(request, callback);
                    }

                    @Override
                    public void onComplete(int result) {
                        callback.onComplete(result);
                    }
                });
            } else {
                this.handleInternal(request, callback);
            }
        } else {
            Debugger.i("%s: ignore request %s", this, request);
            callback.onNext();
        }
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    protected abstract boolean shouldHandle(@NonNull UriRequest var1);

    protected abstract void handleInternal(@NonNull UriRequest var1, @NonNull UriCallback var2);
}

