/*
 * Decompiled with CFR 0.152.
 */
package com.sankuai.waimai.router.core;

import android.content.Context;
import android.net.Uri;
import androidx.annotation.NonNull;
import com.sankuai.waimai.router.core.ChainedHandler;
import com.sankuai.waimai.router.core.Debugger;
import com.sankuai.waimai.router.core.OnCompleteListener;
import com.sankuai.waimai.router.core.UriCallback;
import com.sankuai.waimai.router.core.UriHandler;
import com.sankuai.waimai.router.core.UriRequest;

public class RootUriHandler
extends ChainedHandler {
    private final Context mContext;
    private OnCompleteListener mGlobalOnCompleteListener;

    public RootUriHandler(Context context) {
        this.mContext = context.getApplicationContext();
    }

    public Context getContext() {
        return this.mContext;
    }

    public void lazyInit() {
    }

    public void setGlobalOnCompleteListener(OnCompleteListener listener) {
        this.mGlobalOnCompleteListener = listener;
    }

    public OnCompleteListener getGlobalOnCompleteListener() {
        return this.mGlobalOnCompleteListener;
    }

    @Override
    public RootUriHandler addChildHandler(@NonNull UriHandler handler, int priority) {
        return (RootUriHandler)super.addChildHandler(handler, priority);
    }

    @Override
    public RootUriHandler addChildHandler(@NonNull UriHandler handler) {
        return this.addChildHandler(handler, 0);
    }

    public <T extends UriHandler> T findChildHandlerByClass(Class<T> clazz) {
        for (UriHandler handler : this.getHandlers()) {
            if (!clazz.isInstance(handler)) continue;
            return (T)handler;
        }
        return null;
    }

    public void startUri(@NonNull UriRequest request) {
        if (request == null) {
            String msg = "UriRequest\u4e3a\u7a7a";
            Debugger.fatal(msg, new Object[0]);
            UriRequest req = new UriRequest(this.mContext, Uri.EMPTY).setErrorMessage(msg);
            this.onError(req, 400);
        } else if (request.getContext() == null) {
            String msg = "UriRequest.Context\u4e3a\u7a7a";
            Debugger.fatal(msg, new Object[0]);
            UriRequest req = new UriRequest(this.mContext, request.getUri(), request.getFields()).setErrorMessage(msg);
            this.onError(req, 400);
        } else if (request.isUriEmpty()) {
            String msg = "\u8df3\u8f6c\u94fe\u63a5\u4e3a\u7a7a";
            Debugger.e(msg, new Object[0]);
            request.setErrorMessage(msg);
            this.onError(request, 400);
        } else {
            if (Debugger.isEnableLog()) {
                Debugger.i("", new Object[0]);
                Debugger.i("---> receive request: %s", request.toFullString());
            }
            this.handle(request, new RootUriCallback(request));
        }
    }

    private void onSuccess(@NonNull UriRequest request) {
        OnCompleteListener listener;
        OnCompleteListener globalListener = this.mGlobalOnCompleteListener;
        if (globalListener != null) {
            globalListener.onSuccess(request);
        }
        if ((listener = request.getOnCompleteListener()) != null) {
            listener.onSuccess(request);
        }
    }

    private void onError(@NonNull UriRequest request, int resultCode) {
        OnCompleteListener listener;
        OnCompleteListener globalListener = this.mGlobalOnCompleteListener;
        if (globalListener != null) {
            globalListener.onError(request, resultCode);
        }
        if ((listener = request.getOnCompleteListener()) != null) {
            listener.onError(request, resultCode);
        }
    }

    protected class RootUriCallback
    implements UriCallback {
        private final UriRequest mRequest;

        public RootUriCallback(UriRequest request) {
            this.mRequest = request;
        }

        @Override
        public void onNext() {
            this.onComplete(404);
        }

        @Override
        public void onComplete(int resultCode) {
            switch (resultCode) {
                case 301: {
                    Debugger.i("<--- redirect, result code = %s", resultCode);
                    RootUriHandler.this.startUri(this.mRequest);
                    break;
                }
                case 200: {
                    this.mRequest.putField("com.sankuai.waimai.router.core.result", resultCode);
                    RootUriHandler.this.onSuccess(this.mRequest);
                    Debugger.i("<--- success, result code = %s", resultCode);
                    break;
                }
                default: {
                    this.mRequest.putField("com.sankuai.waimai.router.core.result", resultCode);
                    RootUriHandler.this.onError(this.mRequest, resultCode);
                    Debugger.i("<--- error, result code = %s", resultCode);
                }
            }
        }
    }
}

