/*
 * Decompiled with CFR 0.152.
 */
package com.sankuai.waimai.router.components;

import android.content.Context;
import android.text.TextUtils;
import android.widget.Toast;
import androidx.annotation.NonNull;
import com.sankuai.waimai.router.core.Debugger;
import com.sankuai.waimai.router.core.OnCompleteListener;
import com.sankuai.waimai.router.core.UriRequest;

public class DefaultOnCompleteListener
implements OnCompleteListener {
    public static final DefaultOnCompleteListener INSTANCE = new DefaultOnCompleteListener();

    @Override
    public void onSuccess(@NonNull UriRequest request) {
    }

    @Override
    public void onError(@NonNull UriRequest request, int resultCode) {
        String text = request.getStringField("com.sankuai.waimai.router.core.error.msg", null);
        if (TextUtils.isEmpty((CharSequence)text)) {
            switch (resultCode) {
                case 404: {
                    text = "\u4e0d\u652f\u6301\u7684\u8df3\u8f6c\u94fe\u63a5";
                    break;
                }
                case 403: {
                    text = "\u6ca1\u6709\u6743\u9650";
                    break;
                }
                default: {
                    text = "\u8df3\u8f6c\u5931\u8d25";
                }
            }
        }
        text = text + "(" + resultCode + ")";
        if (Debugger.isEnableDebug()) {
            text = text + "\n" + request.getUri().toString();
        }
        Toast.makeText((Context)request.getContext(), (CharSequence)text, (int)1).show();
    }
}

