/*
 * Decompiled with CFR 0.152.
 */
package com.sankuai.waimai.router.components;

import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.core.app.ActivityCompat;
import com.sankuai.waimai.router.activity.StartActivityAction;
import com.sankuai.waimai.router.components.ActivityLauncher;
import com.sankuai.waimai.router.core.Debugger;
import com.sankuai.waimai.router.core.UriRequest;
import java.util.List;

public class DefaultActivityLauncher
implements ActivityLauncher {
    public static final DefaultActivityLauncher INSTANCE = new DefaultActivityLauncher();
    private boolean mCheckIntentFirst = false;

    public void setCheckIntentFirst(boolean checkIntentFirst) {
        this.mCheckIntentFirst = checkIntentFirst;
    }

    @Override
    public int startActivity(@NonNull UriRequest request, @NonNull Intent intent) {
        Integer flags;
        if (request == null || intent == null) {
            return 500;
        }
        Context context = request.getContext();
        Bundle extra = request.getField(Bundle.class, "com.sankuai.waimai.router.activity.intent_extra");
        if (extra != null) {
            intent.putExtras(extra);
        }
        if ((flags = request.getField(Integer.class, "com.sankuai.waimai.router.activity.flags")) != null) {
            intent.setFlags(flags.intValue());
        }
        Integer requestCode = request.getField(Integer.class, "com.sankuai.waimai.router.activity.request_code");
        boolean limitPackage = request.getBooleanField("com.sankuai.waimai.router.activity.limit_package", false);
        intent.setPackage(context.getPackageName());
        int r = this.startIntent(request, intent, context, requestCode, true);
        if (limitPackage || r == 200) {
            return r;
        }
        intent.setPackage(null);
        return this.startIntent(request, intent, context, requestCode, false);
    }

    protected int startIntent(@NonNull UriRequest request, @NonNull Intent intent, Context context, Integer requestCode, boolean internal) {
        if (!this.checkIntent(context, intent)) {
            return 404;
        }
        if (this.startActivityByAction(request, intent, internal) == 200) {
            return 200;
        }
        return this.startActivityByDefault(request, context, intent, requestCode, internal);
    }

    protected boolean checkIntent(Context context, Intent intent) {
        if (this.mCheckIntentFirst) {
            try {
                PackageManager pm = context.getPackageManager();
                List list = pm.queryIntentActivities(intent, 65536);
                return list != null && list.size() > 0;
            }
            catch (Exception e) {
                Debugger.fatal(e);
                return false;
            }
        }
        return true;
    }

    protected int startActivityByAction(@NonNull UriRequest request, @NonNull Intent intent, boolean internal) {
        try {
            boolean result;
            StartActivityAction action = request.getField(StartActivityAction.class, "com.sankuai.waimai.router.activity.start_activity_action");
            boolean bl = result = action != null && action.startActivity(request, intent);
            if (result) {
                this.doAnimation(request);
                if (internal) {
                    request.putField("com.sankuai.waimai.router.activity.started_activity", 1);
                    Debugger.i("    internal activity started by StartActivityAction, request = %s", request);
                } else {
                    request.putField("com.sankuai.waimai.router.activity.started_activity", 2);
                    Debugger.i("    external activity started by StartActivityAction, request = %s", request);
                }
                return 200;
            }
            return 500;
        }
        catch (ActivityNotFoundException e) {
            Debugger.w(e);
            return 404;
        }
        catch (SecurityException e) {
            Debugger.w(e);
            return 403;
        }
    }

    protected int startActivityByDefault(UriRequest request, @NonNull Context context, @NonNull Intent intent, Integer requestCode, boolean internal) {
        try {
            Bundle options = request.getField(Bundle.class, "com.sankuai.waimai.router.activity.options");
            if (requestCode != null && context instanceof Activity) {
                ActivityCompat.startActivityForResult((Activity)((Activity)context), (Intent)intent, (int)requestCode, (Bundle)options);
            } else {
                ActivityCompat.startActivity((Context)context, (Intent)intent, (Bundle)options);
            }
            this.doAnimation(request);
            if (internal) {
                request.putField("com.sankuai.waimai.router.activity.started_activity", 1);
                Debugger.i("    internal activity started, request = %s", request);
            } else {
                request.putField("com.sankuai.waimai.router.activity.started_activity", 2);
                Debugger.i("    external activity started, request = %s", request);
            }
            return 200;
        }
        catch (ActivityNotFoundException e) {
            Debugger.w(e);
            return 404;
        }
        catch (SecurityException e) {
            Debugger.w(e);
            return 403;
        }
    }

    protected void doAnimation(UriRequest request) {
        Context context = request.getContext();
        int[] anim = request.getField(int[].class, "com.sankuai.waimai.router.activity.animation");
        if (context instanceof Activity && anim != null && anim.length == 2) {
            ((Activity)context).overridePendingTransition(anim[0], anim[1]);
        }
    }
}

