/*
 * Decompiled with CFR 0.152.
 */
package com.sankuai.waimai.router.common;

import android.content.Intent;
import androidx.annotation.NonNull;
import com.sankuai.waimai.router.components.RouterComponents;
import com.sankuai.waimai.router.components.UriSourceTools;
import com.sankuai.waimai.router.core.UriCallback;
import com.sankuai.waimai.router.core.UriHandler;
import com.sankuai.waimai.router.core.UriRequest;

public class StartUriHandler
extends UriHandler {
    public static final String FIELD_TRY_START_URI = "com.sankuai.waimai.router.common.try_start_uri";

    @Override
    protected boolean shouldHandle(@NonNull UriRequest request) {
        return request.getBooleanField(FIELD_TRY_START_URI, true);
    }

    @Override
    protected void handleInternal(@NonNull UriRequest request, @NonNull UriCallback callback) {
        Intent intent = new Intent("android.intent.action.VIEW");
        intent.setData(request.getUri());
        UriSourceTools.setIntentSource(intent, request);
        request.putFieldIfAbsent("com.sankuai.waimai.router.activity.limit_package", this.limitPackage());
        int resultCode = RouterComponents.startActivity(request, intent);
        this.handleResult(callback, resultCode);
    }

    protected boolean limitPackage() {
        return false;
    }

    protected void handleResult(@NonNull UriCallback callback, int resultCode) {
        if (resultCode == 200) {
            callback.onComplete(resultCode);
        } else {
            callback.onNext();
        }
    }

    @Override
    public String toString() {
        return "StartUriHandler";
    }
}

