/*
 * Decompiled with CFR 0.152.
 */
package com.sankuai.waimai.router.common;

import android.content.ActivityNotFoundException;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.fragment.app.Fragment;
import com.sankuai.waimai.router.activity.StartActivityAction;
import com.sankuai.waimai.router.common.DefaultUriRequest;
import com.sankuai.waimai.router.core.Debugger;
import com.sankuai.waimai.router.core.UriRequest;
import java.util.HashMap;

public class FragmentUriRequest
extends DefaultUriRequest {
    public FragmentUriRequest(@NonNull Fragment fragment, @NonNull Uri uri) {
        super(fragment.getContext(), uri);
        this.configStartAction(fragment);
    }

    public FragmentUriRequest(@NonNull Fragment fragment, @NonNull String uri) {
        super(fragment.getContext(), uri);
        this.configStartAction(fragment);
    }

    public FragmentUriRequest(@NonNull Fragment fragment, @NonNull String uri, HashMap<String, Object> extra) {
        super(fragment.getContext(), uri, extra);
        this.configStartAction(fragment);
    }

    private void configStartAction(@NonNull Fragment fragment) {
        this.putField("com.sankuai.waimai.router.activity.start_activity_action", new FragmentStartActivityAction(fragment));
    }

    private class FragmentStartActivityAction
    implements StartActivityAction {
        private Fragment fragment;

        public FragmentStartActivityAction(Fragment fragment) {
            this.fragment = fragment;
        }

        @Override
        public boolean startActivity(@NonNull UriRequest request, @NonNull Intent intent) throws ActivityNotFoundException, SecurityException {
            try {
                Bundle options = request.getField(Bundle.class, "com.sankuai.waimai.router.activity.options");
                Integer requestCode = request.getField(Integer.class, "com.sankuai.waimai.router.activity.request_code");
                if (requestCode != null) {
                    this.fragment.startActivityForResult(intent, requestCode.intValue(), options);
                } else {
                    this.fragment.startActivity(intent, options);
                }
                return true;
            }
            catch (ActivityNotFoundException e) {
                Debugger.w(e);
                return false;
            }
            catch (SecurityException e) {
                Debugger.w(e);
                return false;
            }
        }
    }
}

