/*
 * Decompiled with CFR 0.152.
 */
package com.sankuai.waimai.router.activity;

import android.content.Intent;
import androidx.annotation.NonNull;
import com.sankuai.waimai.router.components.RouterComponents;
import com.sankuai.waimai.router.components.UriSourceTools;
import com.sankuai.waimai.router.core.Debugger;
import com.sankuai.waimai.router.core.UriCallback;
import com.sankuai.waimai.router.core.UriHandler;
import com.sankuai.waimai.router.core.UriRequest;

public abstract class AbsActivityHandler
extends UriHandler {
    @Override
    protected boolean shouldHandle(@NonNull UriRequest request) {
        return true;
    }

    @Override
    protected void handleInternal(@NonNull UriRequest request, @NonNull UriCallback callback) {
        Intent intent = this.createIntent(request);
        if (intent == null || intent.getComponent() == null) {
            Debugger.fatal("AbsActivityHandler.createIntent()\u5e94\u8fd4\u56de\u7684\u5e26\u6709ClassName\u7684\u663e\u5f0f\u8df3\u8f6cIntent", new Object[0]);
            callback.onComplete(500);
            return;
        }
        intent.setData(request.getUri());
        UriSourceTools.setIntentSource(intent, request);
        request.putFieldIfAbsent("com.sankuai.waimai.router.activity.limit_package", this.limitPackage());
        int resultCode = RouterComponents.startActivity(request, intent);
        this.onActivityStartComplete(request, resultCode);
        callback.onComplete(resultCode);
    }

    protected boolean limitPackage() {
        return true;
    }

    @NonNull
    protected abstract Intent createIntent(@NonNull UriRequest var1);

    protected void onActivityStartComplete(@NonNull UriRequest request, int resultCode) {
    }

    @Override
    public String toString() {
        return "ActivityHandler";
    }
}

