/*
 * Decompiled with CFR 0.152.
 */
package com.sankuai.waimai.router;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Looper;
import android.util.Log;
import androidx.annotation.NonNull;
import com.sankuai.waimai.router.common.PageAnnotationHandler;
import com.sankuai.waimai.router.core.Debugger;
import com.sankuai.waimai.router.core.RootUriHandler;
import com.sankuai.waimai.router.core.UriRequest;
import com.sankuai.waimai.router.exception.DefaultServiceException;
import com.sankuai.waimai.router.method.Func0;
import com.sankuai.waimai.router.method.Func1;
import com.sankuai.waimai.router.method.Func2;
import com.sankuai.waimai.router.method.Func3;
import com.sankuai.waimai.router.method.Func4;
import com.sankuai.waimai.router.method.Func5;
import com.sankuai.waimai.router.method.Func6;
import com.sankuai.waimai.router.method.Func7;
import com.sankuai.waimai.router.method.Func8;
import com.sankuai.waimai.router.method.Func9;
import com.sankuai.waimai.router.method.FuncN;
import com.sankuai.waimai.router.service.IFactory;
import com.sankuai.waimai.router.service.ServiceLoader;
import java.util.List;

public class Router {
    @SuppressLint(value={"StaticFieldLeak"})
    private static RootUriHandler ROOT_HANDLER;

    public static void init(@NonNull RootUriHandler rootUriHandler) {
        if (!Debugger.isLogSetting()) {
            Log.w((String)"WMRouter", (String)"!!\u5f53\u524d\u672a\u8bbe\u7f6eLogger,\u5efa\u8bae\u901a\u8fc7 Debugger.setLogger()\u65b9\u6cd5\u8bbe\u7f6eLogger");
            Log.w((String)"WMRouter", (String)"!!\u5e76\u5728\u6d4b\u8bd5\u73af\u5883\u901a\u8fc7 Debugger.EnableLog(true)\u65b9\u6cd5\u5f00\u542f\u65e5\u5fd7");
            Log.w((String)"WMRouter", (String)"!!\u901a\u8fc7Debugger.setEnableDebug(true)\u65b9\u6cd5\u5728\u6d4b\u8bd5\u73af\u5883\u53ca\u65f6\u629b\u51fa\u4e25\u91cd\u7c7b\u578b\u5f02\u5e38");
        }
        if (Looper.myLooper() != Looper.getMainLooper()) {
            Debugger.fatal("\u521d\u59cb\u5316\u65b9\u6cd5init\u5e94\u8be5\u5728\u4e3b\u7ebf\u7a0b\u8c03\u7528", new Object[0]);
        }
        if (ROOT_HANDLER == null) {
            ROOT_HANDLER = rootUriHandler;
        } else {
            Debugger.fatal("\u8bf7\u52ff\u91cd\u590d\u521d\u59cb\u5316UriRouter", new Object[0]);
        }
    }

    public static void lazyInit() {
        ServiceLoader.lazyInit();
        Router.getRootHandler().lazyInit();
    }

    public static RootUriHandler getRootHandler() {
        if (ROOT_HANDLER == null) {
            throw new RuntimeException("\u8bf7\u5148\u8c03\u7528init\u521d\u59cb\u5316UriRouter");
        }
        return ROOT_HANDLER;
    }

    public static void startUri(UriRequest request) {
        Router.getRootHandler().startUri(request);
    }

    public static void startUri(Context context, String uri) {
        Router.getRootHandler().startUri(new UriRequest(context, uri));
    }

    public static void startPageUri(Context context, String path) {
        Router.startUri(context, PageAnnotationHandler.SCHEME_HOST + path);
    }

    public static <T> ServiceLoader<T> loadService(Class<T> clazz) {
        return ServiceLoader.load(clazz);
    }

    public static <I, T extends I> I getService(Class<I> clazz) {
        Object service = ServiceLoader.load(clazz).get("_service_default_impl");
        if (service != null) {
            return (I)service;
        }
        List<T> services = Router.getAllServices(clazz);
        if (services.size() == 1) {
            return (I)services.get(0);
        }
        if (services.size() > 1) {
            Debugger.fatal(DefaultServiceException.foundMoreThanOneImpl(clazz));
        }
        return null;
    }

    public static <I, T extends I> I getService(Class<I> clazz, Context context) {
        Object service = ServiceLoader.load(clazz).get("_service_default_impl", context);
        if (service != null) {
            return (I)service;
        }
        List<T> services = Router.getAllServices(clazz, context);
        if (services.size() == 1) {
            return (I)services.get(0);
        }
        if (services.size() > 1) {
            Debugger.fatal(DefaultServiceException.foundMoreThanOneImpl(clazz));
        }
        return null;
    }

    public static <I, T extends I> I getService(Class<I> clazz, IFactory factory) {
        Object service = ServiceLoader.load(clazz).get("_service_default_impl", factory);
        if (service != null) {
            return (I)service;
        }
        List<T> services = Router.getAllServices(clazz, factory);
        if (services.size() == 1) {
            return (I)services.get(0);
        }
        if (services.size() > 1) {
            Debugger.fatal(DefaultServiceException.foundMoreThanOneImpl(clazz));
        }
        return null;
    }

    public static <I, T extends I> T getService(Class<I> clazz, String key) {
        return ServiceLoader.load(clazz).get(key);
    }

    public static <I, T extends I> T getService(Class<I> clazz, String key, Context context) {
        return ServiceLoader.load(clazz).get(key, context);
    }

    public static <I, T extends I> T getService(Class<I> clazz, String key, IFactory factory) {
        return ServiceLoader.load(clazz).get(key, factory);
    }

    public static <I, T extends I> List<T> getAllServices(Class<I> clazz) {
        return ServiceLoader.load(clazz).getAll();
    }

    public static <I, T extends I> List<T> getAllServices(Class<I> clazz, Context context) {
        return ServiceLoader.load(clazz).getAll(context);
    }

    public static <I, T extends I> List<T> getAllServices(Class<I> clazz, IFactory factory) {
        return ServiceLoader.load(clazz).getAll(factory);
    }

    public static <I, T extends I> Class<T> getServiceClass(Class<I> clazz, String key) {
        return ServiceLoader.load(clazz).getClass(key);
    }

    public static <I, T extends I> List<Class<T>> getAllServiceClasses(Class<I> clazz) {
        return ServiceLoader.load(clazz).getAllClasses();
    }

    public static <T> T callMethod(String key, Object ... args) {
        switch (args.length) {
            case 0: {
                return (T)((Func0)Router.getService(Func0.class, key)).call();
            }
            case 1: {
                return (T)((Func1)Router.getService(Func1.class, key)).call(args[0]);
            }
            case 2: {
                return (T)((Func2)Router.getService(Func2.class, key)).call(args[0], args[1]);
            }
            case 3: {
                return (T)((Func3)Router.getService(Func3.class, key)).call(args[0], args[1], args[2]);
            }
            case 4: {
                return (T)((Func4)Router.getService(Func4.class, key)).call(args[0], args[1], args[2], args[3]);
            }
            case 5: {
                return (T)((Func5)Router.getService(Func5.class, key)).call(args[0], args[1], args[2], args[3], args[4]);
            }
            case 6: {
                return (T)((Func6)Router.getService(Func6.class, key)).call(args[0], args[1], args[2], args[3], args[4], args[5]);
            }
            case 7: {
                return (T)((Func7)Router.getService(Func7.class, key)).call(args[0], args[1], args[2], args[3], args[4], args[5], args[6]);
            }
            case 8: {
                return (T)((Func8)Router.getService(Func8.class, key)).call(args[0], args[1], args[2], args[3], args[4], args[5], args[6], args[7]);
            }
            case 9: {
                return (T)((Func9)Router.getService(Func9.class, key)).call(args[0], args[1], args[2], args[3], args[4], args[5], args[6], args[7], args[8]);
            }
        }
        return (T)((FuncN)Router.getService(FuncN.class, key)).call(args);
    }
}

