/*
 * Decompiled with CFR 0.152.
 */
package com.meetsl.scardview;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Color;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.annotation.ColorInt;
import android.util.AttributeSet;
import android.view.Gravity;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.meetsl.scardview.R;
import com.meetsl.scardview.SCardView;
import com.meetsl.scardview.SCardViewApi17Impl;
import com.meetsl.scardview.SCardViewBaseImpl;
import com.meetsl.scardview.SCardViewDelegate;
import com.meetsl.scardview.SCardViewImpl;
import com.meetsl.scardview.SRoundRectDrawableWithShadow;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000[\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b *\u0001\u0011\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0006\u0010%\u001a\u00020&J\u0006\u0010'\u001a\u00020(J\u0006\u0010)\u001a\u00020\tJ\u0006\u0010*\u001a\u00020\tJ\u0006\u0010+\u001a\u00020\tJ\u0006\u0010,\u001a\u00020\tJ\u0006\u0010-\u001a\u00020(J\u0006\u0010.\u001a\u00020\u0014J\u0006\u0010/\u001a\u00020(J\u0006\u00100\u001a\u00020\u0014J0\u00101\u001a\u0002022\u0006\u00103\u001a\u00020\t2\u0006\u00104\u001a\u00020\t2\u0006\u00105\u001a\u00020\t2\u0006\u00106\u001a\u00020\t2\u0006\u00107\u001a\u00020\u0014H\u0002J0\u00108\u001a\u0002022\u0006\u00109\u001a\u00020\u00142\u0006\u00103\u001a\u00020\t2\u0006\u00104\u001a\u00020\t2\u0006\u00105\u001a\u00020\t2\u0006\u00106\u001a\u00020\tH\u0014J\u0018\u0010:\u001a\u0002022\u0006\u0010;\u001a\u00020\t2\u0006\u0010<\u001a\u00020\tH\u0014J\u0010\u0010=\u001a\u0002022\b\u0010>\u001a\u0004\u0018\u00010&J\u0010\u0010=\u001a\u0002022\b\b\u0001\u0010>\u001a\u00020\tJ\u000e\u0010?\u001a\u0002022\u0006\u0010@\u001a\u00020(J&\u0010A\u001a\u0002022\u0006\u00103\u001a\u00020\t2\u0006\u00104\u001a\u00020\t2\u0006\u00105\u001a\u00020\t2\u0006\u00106\u001a\u00020\tJ\u000e\u0010B\u001a\u0002022\u0006\u0010C\u001a\u00020(J\u0010\u0010D\u001a\u0002022\u0006\u0010E\u001a\u00020\tH\u0016J\u0010\u0010F\u001a\u0002022\u0006\u0010G\u001a\u00020\tH\u0016J(\u0010H\u001a\u0002022\u0006\u00103\u001a\u00020\t2\u0006\u00104\u001a\u00020\t2\u0006\u00105\u001a\u00020\t2\u0006\u00106\u001a\u00020\tH\u0016J(\u0010I\u001a\u0002022\u0006\u0010J\u001a\u00020\t2\u0006\u00104\u001a\u00020\t2\u0006\u0010K\u001a\u00020\t2\u0006\u00106\u001a\u00020\tH\u0016J\u000e\u0010L\u001a\u0002022\u0006\u0010M\u001a\u00020\u0014J\u000e\u0010N\u001a\u0002022\u0006\u0010O\u001a\u00020(J\u000e\u0010P\u001a\u0002022\u0006\u0010Q\u001a\u00020\u0014R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\u00020\u0016X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0019\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\u00020\u0016X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0018R\u000e\u0010\u001c\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001d\u001a\u00020\tX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u001a\u0010\"\u001a\u00020\tX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u001f\"\u0004\b$\u0010!\u00a8\u0006R"}, d2={"Lcom/meetsl/scardview/SCardView;", "Landroid/widget/FrameLayout;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "COLOR_BACKGROUND_ATTR", "", "DEFAULT_CHILD_GRAVITY", "IMPL", "Lcom/meetsl/scardview/SCardViewImpl;", "mCardViewDelegate", "com/meetsl/scardview/SCardView$mCardViewDelegate$1", "Lcom/meetsl/scardview/SCardView$mCardViewDelegate$1;", "mCompatPadding", "", "mContentPadding", "Landroid/graphics/Rect;", "getMContentPadding$SCardView_release", "()Landroid/graphics/Rect;", "mPreventCornerOverlap", "mShadowBounds", "getMShadowBounds$SCardView_release", "mUseCornerArea", "mUserSetMinHeight", "getMUserSetMinHeight$SCardView_release", "()I", "setMUserSetMinHeight$SCardView_release", "(I)V", "mUserSetMinWidth", "getMUserSetMinWidth$SCardView_release", "setMUserSetMinWidth$SCardView_release", "getCardBackgroundColor", "Landroid/content/res/ColorStateList;", "getCardElevation", "", "getContentPaddingBottom", "getContentPaddingLeft", "getContentPaddingRight", "getContentPaddingTop", "getMaxCardElevation", "getPreventCornerOverlap", "getRadius", "getUseCompatPadding", "layoutChildren", "", "left", "top", "right", "bottom", "forceLeftGravity", "onLayout", "changed", "onMeasure", "widthMeasureSpec", "heightMeasureSpec", "setCardBackgroundColor", "color", "setCardElevation", "elevation", "setContentPadding", "setMaxCardElevation", "maxElevation", "setMinimumHeight", "minHeight", "setMinimumWidth", "minWidth", "setPadding", "setPaddingRelative", "start", "end", "setPreventCornerOverlap", "preventCornerOverlap", "setRadius", "radius", "setUseCompatPadding", "useCompatPadding", "SCardView_release"})
public final class SCardView
extends FrameLayout {
    private final int[] COLOR_BACKGROUND_ATTR;
    private final int DEFAULT_CHILD_GRAVITY = 0x800033;
    private SCardViewImpl IMPL;
    private boolean mCompatPadding;
    private boolean mPreventCornerOverlap;
    private boolean mUseCornerArea;
    private int mUserSetMinWidth;
    private int mUserSetMinHeight;
    @NotNull
    private final Rect mContentPadding;
    @NotNull
    private final Rect mShadowBounds;
    private final mCardViewDelegate.1 mCardViewDelegate;

    public final int getMUserSetMinWidth$SCardView_release() {
        return this.mUserSetMinWidth;
    }

    public final void setMUserSetMinWidth$SCardView_release(int n) {
        this.mUserSetMinWidth = n;
    }

    public final int getMUserSetMinHeight$SCardView_release() {
        return this.mUserSetMinHeight;
    }

    public final void setMUserSetMinHeight$SCardView_release(int n) {
        this.mUserSetMinHeight = n;
    }

    @NotNull
    public final Rect getMContentPadding$SCardView_release() {
        return this.mContentPadding;
    }

    @NotNull
    public final Rect getMShadowBounds$SCardView_release() {
        return this.mShadowBounds;
    }

    public void setPadding(int left, int top, int right, int bottom) {
    }

    public void setPaddingRelative(int start, int top, int end, int bottom) {
    }

    public final boolean getUseCompatPadding() {
        return this.mCompatPadding;
    }

    public final void setUseCompatPadding(boolean useCompatPadding) {
        if (this.mCompatPadding != useCompatPadding) {
            this.mCompatPadding = useCompatPadding;
            this.IMPL.onCompatPaddingChanged(this.mCardViewDelegate);
        }
    }

    public final void setContentPadding(int left, int top, int right, int bottom) {
        this.mContentPadding.set(left, top, right, bottom);
        this.IMPL.updatePadding(this.mCardViewDelegate);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int widthMeasureSpec2 = widthMeasureSpec;
        int heightMeasureSpec2 = heightMeasureSpec;
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec2);
        switch (widthMode) {
            case -2147483648: 
            case 0x40000000: {
                int minWidth = (int)Math.ceil(this.IMPL.getMinWidth(this.mCardViewDelegate));
                widthMeasureSpec2 = View.MeasureSpec.makeMeasureSpec((int)Math.max(minWidth, View.MeasureSpec.getSize((int)widthMeasureSpec2)), (int)widthMode);
            }
        }
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec2);
        switch (heightMode) {
            case -2147483648: 
            case 0x40000000: {
                int minHeight = (int)Math.ceil(this.IMPL.getMinHeight(this.mCardViewDelegate));
                heightMeasureSpec2 = View.MeasureSpec.makeMeasureSpec((int)Math.max(minHeight, View.MeasureSpec.getSize((int)heightMeasureSpec2)), (int)heightMode);
            }
        }
        super.onMeasure(widthMeasureSpec2, heightMeasureSpec2);
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        this.layoutChildren(left, top, right, bottom, false);
    }

    /*
     * WARNING - void declaration
     */
    private final void layoutChildren(int left, int top, int right, int bottom, boolean forceLeftGravity) {
        int parentBottom;
        int parentTop;
        int parentRight;
        int parentLeft;
        int halfWidth;
        int count = this.getChildCount();
        Drawable drawable = this.IMPL.getShadowBackground(this.mCardViewDelegate);
        if (drawable == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.meetsl.scardview.SRoundRectDrawableWithShadow");
        }
        SRoundRectDrawableWithShadow bg = (SRoundRectDrawableWithShadow)drawable;
        RectF rectF = bg.getCardRectSize();
        Pair<Float, Float> movePair = bg.getMoveDistance();
        float cornerRadius = bg.getCornerRadius();
        int iex = (int)((double)cornerRadius - Math.sqrt(2.0) * (double)cornerRadius / (double)2 + (double)0.5f);
        if (movePair != null) {
            halfWidth = (right - left) / 2;
            int halfHeight = (bottom - top) / 2;
            float verticalMove = Build.VERSION.SDK_INT >= 21 ? ((Number)movePair.getSecond()).floatValue() : 0.0f;
            float horizontalMove = Build.VERSION.SDK_INT >= 21 ? ((Number)movePair.getFirst()).floatValue() : 0.0f;
            parentLeft = (int)((float)halfWidth - rectF.width() / (float)2 + horizontalMove);
            parentRight = (int)((float)halfWidth + rectF.width() / (float)2 + horizontalMove);
            parentTop = (int)((float)halfHeight - rectF.height() / (float)2 + verticalMove);
            parentBottom = (int)((float)halfHeight + rectF.height() / (float)2 + verticalMove);
            if (!this.mUseCornerArea) {
                parentLeft += iex;
                parentTop += iex;
                parentRight -= iex;
                parentBottom -= iex;
            }
            if (parentLeft < this.getPaddingLeft()) {
                parentLeft = this.getPaddingLeft();
            }
            if (parentRight > right - left - this.getPaddingRight()) {
                parentRight = right - left - this.getPaddingRight();
            }
            if (parentTop < this.getPaddingTop()) {
                parentTop = this.getPaddingTop();
            }
            if (parentBottom > bottom - top - this.getPaddingBottom()) {
                parentBottom = bottom - top - this.getPaddingBottom();
            }
        } else {
            parentLeft = this.getPaddingLeft();
            parentRight = right - left - this.getPaddingRight();
            parentTop = this.getPaddingTop();
            parentBottom = bottom - top - this.getPaddingBottom();
        }
        halfWidth = 0;
        int n = count;
        while (halfWidth < n) {
            void i;
            View child;
            View view = child = this.getChildAt((int)i);
            Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"child");
            if (view.getVisibility() != 8) {
                int n2;
                int n3;
                ViewGroup.LayoutParams layoutParams = child.getLayoutParams();
                if (layoutParams == null) {
                    throw new TypeCastException("null cannot be cast to non-null type android.widget.FrameLayout.LayoutParams");
                }
                FrameLayout.LayoutParams lp = (FrameLayout.LayoutParams)layoutParams;
                int width = child.getMeasuredWidth();
                int height = child.getMeasuredHeight();
                int gravity = lp.gravity;
                if (gravity == -1) {
                    gravity = this.DEFAULT_CHILD_GRAVITY;
                }
                int layoutDirection = this.getLayoutDirection();
                int absoluteGravity = Gravity.getAbsoluteGravity((int)gravity, (int)layoutDirection);
                int verticalGravity = gravity & 0x70;
                switch (absoluteGravity & 7) {
                    case 1: {
                        n3 = parentLeft + (parentRight - parentLeft - width) / 2 + lp.leftMargin - lp.rightMargin;
                        break;
                    }
                    case 0x800005: {
                        if (!forceLeftGravity) {
                            n3 = parentRight - width - lp.rightMargin;
                            break;
                        }
                        n3 = parentLeft + lp.leftMargin;
                        break;
                    }
                    case 0x800003: {
                        n3 = parentLeft + lp.leftMargin;
                        break;
                    }
                    default: {
                        n3 = parentLeft + lp.leftMargin;
                    }
                }
                int childLeft = n3;
                switch (verticalGravity) {
                    case 48: {
                        n2 = parentTop + lp.topMargin;
                        break;
                    }
                    case 16: {
                        n2 = parentTop + (parentBottom - parentTop - height) / 2 + lp.topMargin - lp.bottomMargin;
                        break;
                    }
                    case 80: {
                        n2 = parentBottom - height - lp.bottomMargin;
                        break;
                    }
                    default: {
                        n2 = parentTop + lp.topMargin;
                    }
                }
                int childTop = n2;
                int childRight = childLeft + width;
                int childBottom = childTop + height;
                if (!this.mUseCornerArea) {
                    if (childRight > parentRight) {
                        childRight = parentRight;
                    }
                    if (childBottom > parentBottom) {
                        childBottom = parentBottom;
                    }
                }
                child.layout(childLeft, childTop, childRight, childBottom);
            }
            ++i;
        }
    }

    public void setMinimumWidth(int minWidth) {
        this.mUserSetMinWidth = minWidth;
        super.setMinimumWidth(minWidth);
    }

    public void setMinimumHeight(int minHeight) {
        this.mUserSetMinHeight = minHeight;
        super.setMinimumHeight(minHeight);
    }

    public final void setCardBackgroundColor(@ColorInt int color) {
        this.IMPL.setBackgroundColor(this.mCardViewDelegate, ColorStateList.valueOf((int)color));
    }

    public final void setCardBackgroundColor(@Nullable ColorStateList color) {
        this.IMPL.setBackgroundColor(this.mCardViewDelegate, color);
    }

    @NotNull
    public final ColorStateList getCardBackgroundColor() {
        return this.IMPL.getBackgroundColor(this.mCardViewDelegate);
    }

    public final int getContentPaddingLeft() {
        return this.mContentPadding.left;
    }

    public final int getContentPaddingRight() {
        return this.mContentPadding.right;
    }

    public final int getContentPaddingTop() {
        return this.mContentPadding.top;
    }

    public final int getContentPaddingBottom() {
        return this.mContentPadding.bottom;
    }

    public final void setRadius(float radius) {
        this.IMPL.setRadius(this.mCardViewDelegate, radius);
    }

    public final float getRadius() {
        return this.IMPL.getRadius(this.mCardViewDelegate);
    }

    public final void setCardElevation(float elevation) {
        this.IMPL.setElevation(this.mCardViewDelegate, elevation);
    }

    public final float getCardElevation() {
        return this.IMPL.getElevation(this.mCardViewDelegate);
    }

    public final void setMaxCardElevation(float maxElevation) {
        this.IMPL.setMaxElevation(this.mCardViewDelegate, maxElevation);
    }

    public final float getMaxCardElevation() {
        return this.IMPL.getMaxElevation(this.mCardViewDelegate);
    }

    public final boolean getPreventCornerOverlap() {
        return this.mPreventCornerOverlap;
    }

    public final void setPreventCornerOverlap(boolean preventCornerOverlap) {
        if (preventCornerOverlap != this.mPreventCornerOverlap) {
            this.mPreventCornerOverlap = preventCornerOverlap;
            this.IMPL.onPreventCornerOverlapChanged(this.mCardViewDelegate);
        }
    }

    public SCardView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        ColorStateList backgroundColor;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.COLOR_BACKGROUND_ATTR = new int[]{0x1010031};
        this.DEFAULT_CHILD_GRAVITY = 0x800033;
        this.mContentPadding = new Rect();
        this.mShadowBounds = new Rect();
        this.mCardViewDelegate = new SCardViewDelegate(this){
            private Drawable mCardBackground;
            final /* synthetic */ SCardView this$0;

            public void setCardBackground(@NotNull Drawable drawable) {
                Intrinsics.checkParameterIsNotNull((Object)drawable, (String)"drawable");
                this.mCardBackground = drawable;
                this.this$0.setBackgroundDrawable(drawable);
            }

            public boolean getUseCompatPadding() {
                return this.this$0.getUseCompatPadding();
            }

            public boolean getPreventCornerOverlap() {
                return this.this$0.getPreventCornerOverlap();
            }

            public void setShadowPadding(int left, int top, int right, int bottom) {
                this.this$0.getMShadowBounds$SCardView_release().set(left, top, right, bottom);
                SCardView.access$setPadding$s361595720(this.this$0, left + this.this$0.getMContentPadding$SCardView_release().left, top + this.this$0.getMContentPadding$SCardView_release().top, right + this.this$0.getMContentPadding$SCardView_release().right, bottom + this.this$0.getMContentPadding$SCardView_release().bottom);
            }

            public void setMinWidthHeightInternal(int width, int height) {
                if (width > this.this$0.getMUserSetMinWidth$SCardView_release()) {
                    SCardView.access$setMinimumWidth$s361595720(this.this$0, width);
                }
                if (height > this.this$0.getMUserSetMinHeight$SCardView_release()) {
                    SCardView.access$setMinimumHeight$s361595720(this.this$0, height);
                }
            }

            @Nullable
            public Drawable getCardBackground() {
                return this.mCardBackground;
            }

            @NotNull
            public View getCardView() {
                return (View)this.this$0;
            }
            {
                this.this$0 = $outer;
            }
        };
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.SCardView, defStyleAttr, R.style.CardView);
        if (a.hasValue(R.styleable.SCardView_cardBackgroundColor)) {
            backgroundColor = a.getColorStateList(R.styleable.SCardView_cardBackgroundColor);
        } else {
            TypedArray aa = this.getContext().obtainStyledAttributes(this.COLOR_BACKGROUND_ATTR);
            int themeColorBackground = aa.getColor(0, 0);
            aa.recycle();
            float[] hsv = new float[3];
            Color.colorToHSV((int)themeColorBackground, (float[])hsv);
            backgroundColor = ColorStateList.valueOf((int)(hsv[2] > 0.5f ? this.getResources().getColor(R.color.sl_cardview_light_background) : this.getResources().getColor(R.color.sl_cardview_dark_background)));
        }
        float radius = a.getDimension(R.styleable.SCardView_cardCornerRadius, 0.0f);
        float elevation = a.getDimension(R.styleable.SCardView_cardElevation, 0.0f);
        float maxElevation = a.getDimension(R.styleable.SCardView_cardMaxElevation, 0.0f);
        this.mCompatPadding = a.getBoolean(R.styleable.SCardView_cardUseCompatPadding, false);
        this.mPreventCornerOverlap = a.getBoolean(R.styleable.SCardView_cardPreventCornerOverlap, true);
        this.mUseCornerArea = a.getBoolean(R.styleable.SCardView_cardUseCornerArea, false);
        int defaultPadding = a.getDimensionPixelSize(R.styleable.SCardView_contentPadding, 0);
        this.mContentPadding.left = a.getDimensionPixelSize(R.styleable.SCardView_contentPaddingLeft, defaultPadding);
        this.mContentPadding.top = a.getDimensionPixelSize(R.styleable.SCardView_contentPaddingTop, defaultPadding);
        this.mContentPadding.right = a.getDimensionPixelSize(R.styleable.SCardView_contentPaddingRight, defaultPadding);
        this.mContentPadding.bottom = a.getDimensionPixelSize(R.styleable.SCardView_contentPaddingBottom, defaultPadding);
        if (elevation > maxElevation) {
            maxElevation = elevation;
        }
        int direction = a.getInt(R.styleable.SCardView_cardLightDirection, 3);
        int cardCornerVisibility = a.getInt(R.styleable.SCardView_cardCornerVisibility, 7);
        int shadowStartColor = a.getColor(R.styleable.SCardView_cardShadowStartColor, -1);
        int shadowEndColor = a.getColor(R.styleable.SCardView_cardShadowEndColor, -1);
        this.mUserSetMinWidth = a.getDimensionPixelSize(R.styleable.SCardView_android_minWidth, 0);
        this.mUserSetMinHeight = a.getDimensionPixelSize(R.styleable.SCardView_android_minHeight, 0);
        a.recycle();
        this.IMPL = Build.VERSION.SDK_INT >= 17 ? (SCardViewImpl)(cardCornerVisibility == 7 ? (SCardViewBaseImpl)new SCardViewApi17Impl() : new SCardViewBaseImpl()) : (SCardViewImpl)new SCardViewBaseImpl();
        this.IMPL.initStatic();
        SCardViewDelegate sCardViewDelegate = this.mCardViewDelegate;
        ColorStateList colorStateList = backgroundColor;
        Intrinsics.checkExpressionValueIsNotNull((Object)colorStateList, (String)"backgroundColor");
        this.IMPL.initialize(sCardViewDelegate, context, colorStateList, radius, elevation, maxElevation, direction, cardCornerVisibility, shadowStartColor, shadowEndColor);
    }

    public SCardView(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this(context, null);
    }

    public SCardView(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this(context, attrs, R.attr.cardViewStyle);
    }

    public static final /* synthetic */ void access$setPadding$s361595720(SCardView $this, int p0, int p1, int p2, int p3) {
        super.setPadding(p0, p1, p2, p3);
    }

    public static final /* synthetic */ void access$setMinimumWidth$s361595720(SCardView $this, int p0) {
        super.setMinimumWidth(p0);
    }

    public static final /* synthetic */ void access$setMinimumHeight$s361595720(SCardView $this, int p0) {
        super.setMinimumHeight(p0);
    }
}

