/*
 * Decompiled with CFR 0.152.
 */
package io.github.mavi.kover.plugin;

import com.intellij.rt.coverage.aggregate.api.AggregatorApi;
import com.intellij.rt.coverage.aggregate.api.Request;
import com.intellij.rt.coverage.report.api.Filters;
import com.intellij.rt.coverage.report.api.ReportApi;
import io.github.mavi.kover.plugin.AbstractKoverMojo;
import io.github.mavi.kover.plugin.AggregationGroup;
import io.github.mavi.kover.plugin.ProjectExtensionsKt;
import io.github.mavi.kover.plugin.ReportType;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.maven.model.Resource;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\b\u0010\f\u001a\u00020\rH\u0002J\r\u0010\u000e\u001a\u00020\tH\u0010\u00a2\u0006\u0002\b\u000fJ\b\u0010\u0010\u001a\u00020\tH\u0002J\u0018\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012*\b\u0012\u0004\u0012\u00020\u00140\u0012H\u0002R\u001c\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0000X\u0081\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0015"}, d2={"Lio/github/mavi/kover/plugin/ReportMojo;", "Lio/github/mavi/kover/plugin/AbstractKoverMojo;", "()V", "reportFormats", "", "Lio/github/mavi/kover/plugin/ReportType;", "getReportFormats$kover_maven_plugin", "()Ljava/util/Set;", "aggregateRawReports", "", "filters", "Lcom/intellij/rt/coverage/report/api/Filters;", "canExecute", "", "executeMojo", "executeMojo$kover_maven_plugin", "generateReports", "asPatterns", "", "Ljava/util/regex/Pattern;", "", "kover-maven-plugin"})
@Mojo(name="report", defaultPhase=LifecyclePhase.VERIFY, threadSafe=true)
@SourceDebugExtension(value={"SMAP\nReportMojo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReportMojo.kt\nio/github/mavi/kover/plugin/ReportMojo\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,98:1\n1549#2:99\n1620#2,3:100\n1549#2:103\n1620#2,3:104\n1549#2:107\n1620#2,3:108\n1549#2:111\n1620#2,3:112\n*S KotlinDebug\n*F\n+ 1 ReportMojo.kt\nio/github/mavi/kover/plugin/ReportMojo\n*L\n47#1:99\n47#1:100,3\n48#1:103\n48#1:104,3\n85#1:107\n85#1:108,3\n96#1:111\n96#1:112,3\n*E\n"})
public final class ReportMojo
extends AbstractKoverMojo {
    @Parameter(property="kover.reportFormats", defaultValue="HTML,XML")
    @NotNull
    private final Set<ReportType> reportFormats;

    public ReportMojo() {
        ReportType[] reportTypeArray = new ReportType[]{ReportType.HTML, ReportType.XML};
        this.reportFormats = SetsKt.mutableSetOf((Object[])reportTypeArray);
    }

    @NotNull
    public final Set<ReportType> getReportFormats$kover_maven_plugin() {
        return this.reportFormats;
    }

    @Override
    public void executeMojo$kover_maven_plugin() {
        if (!this.canExecute()) {
            this.getLog().info((CharSequence)"Skipping Kover execution because no report file was found.");
            return;
        }
        this.generateReports();
    }

    private final boolean canExecute() {
        LinkOption[] linkOptionArray = new LinkOption[]{};
        return Files.exists(ProjectExtensionsKt.instrumentation(this.getProject$kover_maven_plugin()), Arrays.copyOf(linkOptionArray, linkOptionArray.length));
    }

    /*
     * WARNING - void declaration
     */
    private final void generateReports() {
        String it;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Filters filters = new Filters(this.asPatterns(CollectionsKt.toList((Iterable)this.getIncludesClasses$kover_maven_plugin())), this.asPatterns(CollectionsKt.toList((Iterable)this.getExcludesClasses$kover_maven_plugin())), this.asPatterns(CollectionsKt.toList((Iterable)this.getExcludesAnnotations$kover_maven_plugin())));
        this.aggregateRawReports(filters);
        List reports = CollectionsKt.listOf((Object)ProjectExtensionsKt.aggregationInstrumentation(this.getProject$kover_maven_plugin()).toFile());
        List outputRoots = CollectionsKt.listOf((Object)new File(this.getProject$kover_maven_plugin().getBuild().getOutputDirectory()));
        Set set = SetsKt.setOf((Object)this.getProject$kover_maven_plugin().getBuild().getSourceDirectory());
        List list = this.getProject$kover_maven_plugin().getBuild().getResources();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getResources(...)");
        Iterable iterable = list;
        Collection<File> collection = set;
        boolean $i$f$map = false;
        void var7_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Resource resource = (Resource)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(it.getDirectory());
        }
        $this$map$iv = SetsKt.plus((Set)collection, (Iterable)CollectionsKt.toSet((Iterable)((List)destination$iv$iv)));
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            it = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new File((String)p0));
        }
        List sourceRoots = (List)destination$iv$iv;
        if (this.reportFormats.contains((Object)ReportType.XML)) {
            ReportApi.xmlReport((File)ProjectExtensionsKt.xmlOutput(this.getProject$kover_maven_plugin()).toFile(), (List)reports, (List)outputRoots, (List)sourceRoots, (Filters)filters);
        }
        if (this.reportFormats.contains((Object)ReportType.HTML)) {
            ReportApi.htmlReport((File)ProjectExtensionsKt.htmlOutputDir(this.getProject$kover_maven_plugin()).toFile(), (String)"Kover Report", (String)Charset.defaultCharset().name(), (List)reports, (List)outputRoots, (List)sourceRoots, (Filters)filters);
        }
        if (this.reportFormats.contains((Object)ReportType.HTML)) {
            this.getLog().info((CharSequence)("Kover: HTML report for '" + this.getProject$kover_maven_plugin().getName() + "' file://" + ProjectExtensionsKt.htmlOutputDir(this.getProject$kover_maven_plugin()) + "/index.html"));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void aggregateRawReports(Filters filters) {
        void $this$mapTo$iv$iv;
        List aggregationGroups = CollectionsKt.listOf((Object)new AggregationGroup(ProjectExtensionsKt.aggregationInstrumentation(this.getProject$kover_maven_plugin()), ProjectExtensionsKt.aggregationMap(this.getProject$kover_maven_plugin())));
        Iterable $this$map$iv = aggregationGroups;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void group;
            AggregationGroup aggregationGroup = (AggregationGroup)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new Request(filters, group.getIc().toFile(), group.getSmap().toFile()));
        }
        List requests = (List)destination$iv$iv;
        AggregatorApi.aggregate((List)requests, (List)CollectionsKt.listOf((Object)ProjectExtensionsKt.instrumentation(this.getProject$kover_maven_plugin()).toFile()), (List)CollectionsKt.listOf((Object)new File(this.getProject$kover_maven_plugin().getBuild().getOutputDirectory())));
    }

    /*
     * WARNING - void declaration
     */
    private final List<Pattern> asPatterns(List<String> $this$asPatterns) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = $this$asPatterns;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Pattern.compile(ProjectExtensionsKt.wildcardsToRegex((String)it)));
        }
        return (List)destination$iv$iv;
    }
}

