/*
 * Decompiled with CFR 0.152.
 */
package io.github.mavi.kover.plugin;

import io.github.mavi.kover.plugin.AbstractKoverMojo;
import io.github.mavi.kover.plugin.ProjectExtensionsKt;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0002\b\u0007\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0002J\r\u0010\u0005\u001a\u00020\u0006H\u0010\u00a2\u0006\u0002\b\u0007J\"\u0010\b\u001a\u00020\u0006*\u00020\t2\u0006\u0010\n\u001a\u00020\t2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\fH\u0002\u00a8\u0006\u000e"}, d2={"Lio/github/mavi/kover/plugin/AgentMojo;", "Lio/github/mavi/kover/plugin/AbstractKoverMojo;", "()V", "buildJvmAgentArgs", "", "executeMojo", "", "executeMojo$kover_maven_plugin", "writeAgentArgs", "Ljava/nio/file/Path;", "instrumentationFile", "excludedClasses", "", "Companion", "kover-maven-plugin"})
@Mojo(name="prepare-agent", defaultPhase=LifecyclePhase.INITIALIZE, requiresDependencyResolution=ResolutionScope.RUNTIME, threadSafe=true)
@SourceDebugExtension(value={"SMAP\nAgentMojo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AgentMojo.kt\nio/github/mavi/kover/plugin/AgentMojo\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,101:1\n1855#2,2:102\n*S KotlinDebug\n*F\n+ 1 AgentMojo.kt\nio/github/mavi/kover/plugin/AgentMojo\n*L\n46#1:102,2\n*E\n"})
public final class AgentMojo
extends AbstractKoverMojo {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String AGENT_ARTIFACT_NAME = "org.jetbrains.intellij.deps:intellij-coverage-agent";
    private static final boolean TRACKING_PER_TEST = false;
    private static final boolean CALCULATE_FOR_UNLOADED_CLASSES = false;
    private static final boolean APPEND_TO_DATA_FILE = true;
    private static final boolean LINING_ONLY_MODE = false;
    @NotNull
    private static final String ENABLE_TRACING = "idea.new.tracing.coverage=true";
    @NotNull
    private static final String PRINT_ONLY_ERRORS = "idea.coverage.log.level=error";
    @NotNull
    private static final String IGNORE_STATIC_CONSTRUCTORS = "coverage.ignore.private.constructor.util.class=true";
    @NotNull
    private static final String DO_NOT_COUNT_HIT_AMOUNT = "idea.coverage.calculate.hits=false";

    @Override
    public void executeMojo$kover_maven_plugin() {
        Properties projectProperties = this.getProject$kover_maven_plugin().getProperties();
        Intrinsics.checkNotNull((Object)projectProperties);
        ((Map)projectProperties).put("argLine", this.buildJvmAgentArgs());
        this.getLog().info((CharSequence)("argLine set to " + projectProperties.get("argLine")));
    }

    private final String buildJvmAgentArgs() {
        Path argsFile = ProjectExtensionsKt.argsFile(this.getProject$kover_maven_plugin());
        this.writeAgentArgs(argsFile, ProjectExtensionsKt.instrumentation(this.getProject$kover_maven_plugin()), this.getExcludesClasses$kover_maven_plugin());
        Object[] objectArray = new String[5];
        Artifact artifact = this.getPluginArtifactMap$kover_maven_plugin().get(AGENT_ARTIFACT_NAME);
        Intrinsics.checkNotNull((Object)artifact);
        objectArray[0] = "-javaagent:" + artifact.getFile().getCanonicalPath() + "=" + argsFile.normalize();
        objectArray[1] = "-Didea.new.tracing.coverage=true";
        objectArray[2] = "-Didea.coverage.log.level=error";
        objectArray[3] = "-Dcoverage.ignore.private.constructor.util.class=true";
        objectArray[4] = "-Didea.coverage.calculate.hits=false";
        return CollectionsKt.joinToString$default((Iterable)CollectionsKt.mutableListOf((Object[])objectArray), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
    }

    private final void writeAgentArgs(Path $this$writeAgentArgs, Path instrumentationFile, Set<String> excludedClasses) {
        Object object = new String[]{((Object)instrumentationFile).toString(), "false", "false", "true", "false"};
        List lines = CollectionsKt.mutableListOf((Object[])object);
        if (!((Collection)excludedClasses).isEmpty()) {
            lines.add("-exclude");
            Iterable $this$forEach$iv = excludedClasses;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String e = (String)element$iv;
                boolean bl = false;
                lines.add(ProjectExtensionsKt.wildcardsToRegex(e));
            }
        }
        object = $this$writeAgentArgs;
        OpenOption[] openOptionArray = new OpenOption[]{};
        Charset charset = Charsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)Files.write((Path)object, (Iterable<? extends CharSequence>)lines, charset, (OpenOption[])Arrays.copyOf(openOptionArray, openOptionArray.length)), (String)"write(this, lines, charset, *options)");
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lio/github/mavi/kover/plugin/AgentMojo$Companion;", "", "()V", "AGENT_ARTIFACT_NAME", "", "APPEND_TO_DATA_FILE", "", "CALCULATE_FOR_UNLOADED_CLASSES", "DO_NOT_COUNT_HIT_AMOUNT", "ENABLE_TRACING", "IGNORE_STATIC_CONSTRUCTORS", "LINING_ONLY_MODE", "PRINT_ONLY_ERRORS", "TRACKING_PER_TEST", "kover-maven-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

