/*
 * Decompiled with CFR 0.152.
 */
package io.github.marcopotok.jpb;

import io.github.marcopotok.jpb.DefaultPrefetchEngine;
import io.github.marcopotok.jpb.PrefetchEngine;

public class PredicateBuilderOptions {
    private final boolean joinCacheIsEnabled;
    private final PrefetchEngine prefetchEngine;

    private PredicateBuilderOptions(boolean joinCacheIsEnabled, PrefetchEngine prefetchEngine) {
        this.joinCacheIsEnabled = joinCacheIsEnabled;
        this.prefetchEngine = prefetchEngine;
    }

    public static PredicateBuilderOptions createDefault() {
        return PredicateBuilderOptions.builder().build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean isJoinCacheIsEnabled() {
        return this.joinCacheIsEnabled;
    }

    public PrefetchEngine getPrefetchEngine() {
        return this.prefetchEngine;
    }

    public static final class Builder {
        private boolean joinCacheIsEnabled = true;
        private PrefetchEngine prefetchEngine = new DefaultPrefetchEngine();

        private Builder() {
        }

        public Builder withoutJoinsCache() {
            this.joinCacheIsEnabled = false;
            return this;
        }

        public Builder withPrefetchEngine(PrefetchEngine prefetchEngine) {
            this.prefetchEngine = prefetchEngine;
            return this;
        }

        public PredicateBuilderOptions build() {
            return new PredicateBuilderOptions(this.joinCacheIsEnabled, this.prefetchEngine);
        }
    }
}

