/*
 * Decompiled with CFR 0.152.
 */
package io.github.marcopotok.jpb;

import io.github.marcopotok.jpb.Clause;
import io.github.marcopotok.jpb.Operator;
import io.github.marcopotok.jpb.Operators;
import io.github.marcopotok.jpb.PredicateBuilderOptions;
import io.github.marcopotok.jpb.PredicateContext;
import io.github.marcopotok.jpb.PredicateRepository;
import io.github.marcopotok.jpb.PrefetchEngine;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.From;
import jakarta.persistence.criteria.Join;
import jakarta.persistence.criteria.JoinType;
import jakarta.persistence.criteria.Path;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Subquery;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

public class PredicateBuilder<T> {
    private static final String WILDCARD_REQUEST = "\\*";
    private static final String WILDCARD_DB = "%";
    private static final PredicateContext<?> DISJUNCTION = (root, query, cb) -> cb.disjunction();
    private static final PredicateContext<?> CONJUNCTION = (root, query, cb) -> cb.conjunction();
    private final PredicateRepository<T> predicates = new PredicateRepository();
    private final Map<String, Join<?, T>> joinCache = new HashMap();
    private final Collection<String> prefetches = new LinkedList<String>();
    private final PrefetchEngine prefetchEngine;
    private final boolean isUniqueJoins;

    public PredicateBuilder() {
        this(PredicateBuilderOptions.createDefault());
    }

    public PredicateBuilder(PredicateBuilderOptions options) {
        Objects.requireNonNull(options, "Options must not be null");
        this.prefetchEngine = options.getPrefetchEngine();
        this.isUniqueJoins = options.isJoinCacheIsEnabled();
    }

    public static <T> PredicateBuilder<T> builder() {
        return new PredicateBuilder<T>();
    }

    public static <T> PredicateBuilder<T> of(Class<T> clazz) {
        return PredicateBuilder.builder();
    }

    public Predicate build(Root<T> root, CriteriaQuery<?> query, CriteriaBuilder criteriaBuilder) {
        this.prefetches.forEach(prefetch -> this.prefetchEngine.prefetch((String)prefetch, root, query));
        return this.predicates.stream().map(predicateContext -> predicateContext.toPredicate(root, query, criteriaBuilder)).reduce((arg_0, arg_1) -> ((CriteriaBuilder)criteriaBuilder).and(arg_0, arg_1)).orElse(this.conjunction().toPredicate(root, query, criteriaBuilder));
    }

    public PredicateBuilder<T> and(PredicateBuilder<T> other) {
        if (other != null) {
            other.predicates.stream().forEach(this.predicates::add);
            this.prefetches.addAll(other.prefetches);
        }
        return this;
    }

    public PredicateBuilder<T> and() {
        return this;
    }

    public PredicateBuilder<T> distinct() {
        this.predicates.add((root, criteriaQuery, criteriaBuilder) -> {
            criteriaQuery.distinct(true);
            return criteriaBuilder.conjunction();
        });
        return this;
    }

    public PredicateBuilder<T> prefetch(String attributes) {
        this.prefetches.add(attributes);
        return this;
    }

    public <U> PredicateBuilder<T> withId(U id) {
        return this.withProperty("id", id);
    }

    public <U> PredicateBuilder<T> withProperty(String name, U value) {
        this.addPredicateContextIfHasValue(name, Operators.EQUALS, value);
        return this;
    }

    public <U> PredicateBuilder<T> withRequiredProperty(String name, U value) {
        if (value == null) {
            this.disjunct();
            return this;
        }
        return this.withProperty(name, value);
    }

    public <U extends String> PredicateBuilder<T> withPropertyIgnoreCase(String name, U value) {
        this.addPredicateContextIfHasValue(name, Operators.EQUALS_UPPER_CASE, value != null ? value.toUpperCase(Locale.ROOT) : null);
        return this;
    }

    public <U extends String> PredicateBuilder<T> withRequiredProperty(String name, U value) {
        return this.withRequiredProperty(name, value == null || value.isEmpty() ? null : (U)value);
    }

    public <U> PredicateBuilder<T> withPropertyNot(String name, U value) {
        this.addPredicateContextIfHasValue(name, Operators.NOT_EQUALS, value);
        return this;
    }

    public <U extends String> PredicateBuilder<T> withPropertyNotIgnoreCase(String name, U value) {
        this.addPredicateContextIfHasValue(name, Operators.NOT_EQUALS_UPPER_CASE, value != null ? value.toUpperCase(Locale.ROOT) : null);
        return this;
    }

    public PredicateBuilder<T> withPropertyIn(String name, Collection<?> values) {
        this.addPredicateContextIfHasValue(name, Operators.IN, values);
        return this;
    }

    public PredicateBuilder<T> withRequiredPropertyIn(String name, Collection<?> values) {
        if (values == null || values.isEmpty()) {
            this.disjunct();
            return this;
        }
        return this.withPropertyIn(name, values);
    }

    public PredicateBuilder<T> withPropertyNotIn(String name, Collection<?> values) {
        this.addPredicateContextIfHasValue(name, Operators.NOT_IN, values);
        return this;
    }

    public PredicateBuilder<T> withNullProperty(String name) {
        this.addPredicateContext(name, Operators.IS_NULL, null);
        return this;
    }

    public PredicateBuilder<T> withNotNullProperty(String name) {
        this.addPredicateContext(name, Operators.NOT_NULL, null);
        return this;
    }

    public PredicateBuilder<T> withPropertyLikeIgnoreCase(String name, String value) {
        if (value != null) {
            this.addPredicateContextIfHasValue(name, Operators.LIKE_UPPER_CASE, value.replaceAll(WILDCARD_REQUEST, WILDCARD_DB).toUpperCase(Locale.ROOT));
        }
        return this;
    }

    public PredicateBuilder<T> withPropertyStartingWith(String name, String value) {
        String likeValue = value == null ? WILDCARD_DB : value.toUpperCase(Locale.ROOT) + WILDCARD_DB;
        this.addPredicateContextIfHasValue(name, Operators.LIKE_UPPER_CASE, likeValue);
        return this;
    }

    public <U extends Comparable<? super U>> PredicateBuilder<T> withPropertyAfter(String name, U from) {
        this.addPredicateContextIfHasValue(name, (value, path, cb) -> cb.greaterThan(path, value), from);
        return this;
    }

    public <X extends Comparable<? super X>> PredicateBuilder<T> withPropertyAfterInclusive(String name, X from) {
        this.addPredicateContextIfHasValue(name, (value, path, cb) -> cb.greaterThanOrEqualTo(path, value), from);
        return this;
    }

    public <X extends Comparable<? super X>> PredicateBuilder<T> withPropertyBefore(String name, X to) {
        this.addPredicateContextIfHasValue(name, (value, path, cb) -> cb.lessThan(path, value), to);
        return this;
    }

    public <X extends Comparable<? super X>> PredicateBuilder<T> withPropertyBeforeInclusive(String name, X to) {
        this.addPredicateContextIfHasValue(name, (value, path, cb) -> cb.lessThanOrEqualTo(path, value), to);
        return this;
    }

    public <X extends Comparable<X>> PredicateBuilder<T> withPropertyMaxValue(Class<T> entityClass, Class<X> propertyClass, String name) {
        this.predicates.add((root, query, cb) -> {
            Subquery subQuery = query.subquery(propertyClass);
            Root subRoot = subQuery.from(entityClass);
            Path x = subRoot.get(name);
            subQuery.select(cb.greatest((Expression)x));
            return cb.equal((Expression)root.get(name), (Expression)subQuery);
        });
        return this;
    }

    public <U> PredicateBuilder<T> with(U value, Function<U, Clause> operator) {
        Objects.requireNonNull(operator, "Operator cannot be null");
        if (value != null) {
            this.with(operator.apply(value));
        }
        return this;
    }

    public PredicateBuilder<T> with(Clause clause) {
        if (clause != null) {
            this.predicates.add((root, criteriaQuery, criteriaBuilder) -> clause.toPredicate(criteriaBuilder, (path, joinOn) -> this.getPropertyPath(root, path, joinOn)));
        }
        return this;
    }

    public PredicateBuilder<T> groupBy(String ... names) {
        this.predicates.add((root, query, criteriaBuilder) -> {
            query.groupBy(Arrays.stream(names).map(arg_0 -> ((Root)root).get(arg_0)).collect(Collectors.toList()));
            return criteriaBuilder.conjunction();
        });
        return this;
    }

    public PredicateBuilder<T> project(String ... names) {
        this.predicates.add((root, query, criteriaBuilder) -> {
            query.multiselect(Arrays.stream(names).map(arg_0 -> ((Root)root).get(arg_0)).collect(Collectors.toList()));
            return criteriaBuilder.conjunction();
        });
        return this;
    }

    private <U> void addPredicateContextIfHasValue(String name, Operator<U> operator, U value) {
        if (value != null) {
            this.addPredicateContext(name, operator, value);
        }
    }

    private <U> void addPredicateContext(String name, Operator<U> operator, U value) {
        Objects.requireNonNull(name, "Property name cannot be null");
        this.predicates.add((root, criteriaQuery, criteriaBuilder) -> {
            Path propertyPath = this.getPropertyPath(root, name, null);
            return operator.toPredicate(value, (Expression)propertyPath, criteriaBuilder);
        });
    }

    private <U> Path<U> getPropertyPath(Root<T> root, String key, Function<Join<?, ?>, Predicate> joinOn) {
        String[] split = key.split("\\.");
        return this.getRelationPath((From<?, T>)root, split, joinOn).get(split[split.length - 1]);
    }

    private From<?, T> getRelationPath(From<?, T> path, String[] split, Function<Join<?, ?>, Predicate> joinOn) {
        Object currentPath = "";
        From<?, T> fromPath = path;
        for (int i = 0; i < split.length - 1; ++i) {
            String attributeName = split[i];
            currentPath = (String)currentPath + "." + attributeName;
            fromPath = this.getPath((String)currentPath, fromPath, attributeName);
        }
        return this.addRestrictions(fromPath, joinOn);
    }

    private From<?, T> addRestrictions(From<?, T> path, Function<Join<?, ?>, Predicate> joinOn) {
        if (path instanceof Join && joinOn != null) {
            Join join = (Join)path;
            return join.on((Expression)joinOn.apply(join));
        }
        return path;
    }

    private Join<?, T> getPath(String currentPath, From<?, T> path, String attributeName) {
        return this.isUniqueJoins ? this.joinCache.computeIfAbsent(currentPath, ignored -> path.join(attributeName, JoinType.LEFT)) : path.join(attributeName, JoinType.LEFT);
    }

    private void disjunct() {
        this.predicates.set(this.disjunction());
        this.predicates.freeze();
    }

    private PredicateContext<T> conjunction() {
        return CONJUNCTION;
    }

    private PredicateContext<T> disjunction() {
        return DISJUNCTION;
    }
}

