/*
 * Decompiled with CFR 0.152.
 */
package io.github.marcopotok.jpb;

import io.github.marcopotok.jpb.PrefetchEngine;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Fetch;
import jakarta.persistence.criteria.FetchParent;
import jakarta.persistence.criteria.JoinType;
import jakarta.persistence.criteria.Root;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class DefaultPrefetchEngine
implements PrefetchEngine {
    private static final Pattern NESTED_ATTRIBUTES_MATCHER = Pattern.compile("^\\[(.*)]$");
    private static final int NESTED_LIST_GROUP = 1;
    private static final char LIST_START_CHAR = '[';
    private static final char LIST_END_CHAR = ']';
    private static final String ATTRIBUTE_CHAIN_DELIMITER = "\\.";
    private static final char ATTRIBUTES_DELIMITER = ',';
    private final Map<String, Fetch<?, ?>> fetchCache = new HashMap();

    DefaultPrefetchEngine() {
    }

    @Override
    public <T> void prefetch(String attributeList, Root<T> root, CriteriaQuery<?> query) {
        if (Long.class != query.getResultType() && Long.TYPE != query.getResultType() && !attributeList.isBlank()) {
            this.prefetch((FetchParent<?, ?>)root, attributeList, "");
        }
    }

    private void prefetch(FetchParent<?, ?> node, String attributeList, String currentPath) {
        String[] split;
        for (String rootAttributes : split = this.splitSameLevel(attributeList)) {
            this.prefetchChain(node, currentPath, rootAttributes);
        }
    }

    private void prefetchChain(FetchParent<?, ?> node, String currentPath, String rootAttributes) {
        String[] attributes = this.getAttributes(rootAttributes);
        FetchParent<?, ?> nodeFetch = node;
        for (String attribute : attributes) {
            Matcher matcher = NESTED_ATTRIBUTES_MATCHER.matcher(attribute);
            if (matcher.matches()) {
                this.prefetch(nodeFetch, matcher.group(1), (String)currentPath);
                continue;
            }
            currentPath = (String)currentPath + "." + attribute;
            nodeFetch = this.fetch((String)currentPath, nodeFetch, attribute);
        }
    }

    private String[] splitSameLevel(String attributeList) {
        List<Integer> splitIndexes = this.calculateSplitIndexes(attributeList);
        String[] split = new String[splitIndexes.size() + 1];
        int l = splitIndexes.size() + 1;
        for (int i = 0; i < l; ++i) {
            boolean firstIteration = i == 0;
            boolean lastIteration = i == l - 1;
            int beginIndex = firstIteration ? 0 : splitIndexes.get(i - 1) + 1;
            int endIndex = lastIteration ? attributeList.length() : splitIndexes.get(i).intValue();
            split[i] = attributeList.substring(beginIndex, endIndex);
        }
        return split;
    }

    private List<Integer> calculateSplitIndexes(String attributeList) {
        ArrayList<Integer> splitIndexes = new ArrayList<Integer>();
        char[] charArray = attributeList.toCharArray();
        int nestingLevel = 0;
        int charArrayLength = charArray.length;
        for (int i = 0; i < charArrayLength; ++i) {
            char currentChar = charArray[i];
            if (currentChar == '[') {
                ++nestingLevel;
            }
            if (currentChar == ']') {
                --nestingLevel;
            }
            if (nestingLevel != 0 || currentChar != ',') continue;
            splitIndexes.add(i);
        }
        return splitIndexes;
    }

    private Fetch<?, ?> fetch(String currentPath, FetchParent<?, ?> node, String attributePath) {
        return this.fetchCache.computeIfAbsent(currentPath, ignored -> node.fetch(attributePath, JoinType.LEFT));
    }

    private String[] getAttributes(String attributeList) {
        int indexOfList = attributeList.indexOf(91);
        if (indexOfList < 0) {
            return attributeList.split(ATTRIBUTE_CHAIN_DELIMITER);
        }
        String[] split = attributeList.substring(0, indexOfList).split(ATTRIBUTE_CHAIN_DELIMITER);
        String[] attributes = Arrays.copyOf(split, split.length + 1);
        attributes[attributes.length - 1] = attributeList.substring(indexOfList);
        return attributes;
    }
}

