/*
 * Decompiled with CFR 0.152.
 */
package io.github.marcopotok.jpb;

import io.github.marcopotok.jpb.Clause;
import io.github.marcopotok.jpb.PathProvider;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.Predicate;
import java.io.Serializable;

class ClauseComposition {
    ClauseComposition() {
    }

    static Clause composed(Clause lhs, Clause rhs, Combiner combiner) {
        return (builder, provider) -> {
            Predicate thisPredicate = ClauseComposition.toPredicate(lhs, builder, provider);
            Predicate otherPredicate = ClauseComposition.toPredicate(rhs, builder, provider);
            if (thisPredicate == null) {
                return otherPredicate;
            }
            return otherPredicate == null ? thisPredicate : combiner.combine(builder, thisPredicate, otherPredicate);
        };
    }

    private static Predicate toPredicate(Clause clause, CriteriaBuilder criteriaBuilder, PathProvider pathProvider) {
        return clause == null ? null : clause.toPredicate(criteriaBuilder, pathProvider);
    }

    static interface Combiner
    extends Serializable {
        public Predicate combine(CriteriaBuilder var1, Predicate var2, Predicate var3);
    }
}

