/*
 * Decompiled with CFR 0.152.
 */
package io.github.marceltanuri.security.commons.oauth.token.internal;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.github.marceltanuri.security.commons.oauth.token.api.TokenService;
import io.github.marceltanuri.security.commons.oauth.token.api.TokenServiceException;
import io.github.marceltanuri.security.commons.oauth.token.internal.TokenCacheService;
import io.github.marceltanuri.security.commons.oauth.token.internal.TokenResponse;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={TokenService.class})
public class ConfigurableTokenService
implements TokenService {
    private HttpClient _httpClient;
    private final ObjectMapper _objectMapper = new ObjectMapper();
    @Reference
    private TokenCacheService _tokenCacheService;

    @Override
    public String getAccessToken(TokenService.ClientCredentialsSettings settings) {
        String scope = settings.scope();
        String cacheKey = settings.clientId() + ":" + scope;
        TokenResponse token = this._tokenCacheService.get(cacheKey);
        if (token != null) {
            return token.getAccessToken();
        }
        token = this._fetchAccessToken(settings);
        this._tokenCacheService.put(cacheKey, token);
        return token.getAccessToken();
    }

    @Activate
    protected void activate(Map<String, Object> properties) {
        this._httpClient = HttpClient.newHttpClient();
    }

    private TokenResponse _fetchAccessToken(TokenService.ClientCredentialsSettings settings) {
        String audience;
        HashMap<String, String> formData = new HashMap<String, String>();
        formData.put("client_id", settings.clientId());
        formData.put("client_secret", settings.clientSecret());
        formData.put("grant_type", "client_credentials");
        String scope = settings.scope();
        if (scope != null && !scope.isBlank()) {
            formData.put("scope", scope);
        }
        if ((audience = settings.audience()) != null && !audience.isBlank()) {
            formData.put("audience", audience);
        }
        String form = formData.entrySet().stream().map(e -> (String)e.getKey() + "=" + (String)e.getValue()).collect(Collectors.joining("&"));
        HttpRequest httpRequest = HttpRequest.newBuilder().uri(URI.create(settings.tokenEndpoint())).header("Content-Type", "application/x-www-form-urlencoded").POST(HttpRequest.BodyPublishers.ofString(form, StandardCharsets.UTF_8)).build();
        try {
            HttpResponse<String> response = this._httpClient.send(httpRequest, HttpResponse.BodyHandlers.ofString());
            if (response.statusCode() == 200) {
                return (TokenResponse)this._objectMapper.readValue(response.body(), TokenResponse.class);
            }
            throw new TokenServiceException("Failed to retrieve access token. Status code: " + response.statusCode());
        }
        catch (IOException | InterruptedException exception) {
            throw new TokenServiceException("Error fetching access token", exception);
        }
    }
}

