/*
 * Decompiled with CFR 0.152.
 */
package io.github.marceltanuri.commons.oauthclient.internal;

import io.github.marceltanuri.commons.oauthclient.api.OAuth2ClientSettings;
import io.github.marceltanuri.commons.oauthclient.api.OAuth2Service;
import io.github.marceltanuri.commons.oauthclient.internal.OAuth2ClientService;
import io.github.marceltanuri.commons.oauthclient.internal.OAuth2ClientSettingsProxy;
import io.github.marceltanuri.commons.oauthclient.internal.OAuth2TokenCache;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.metatype.annotations.Designate;

@Component(configurationPid={"io.github.marceltanuri.commons.oauthclient.api.OAuth2ClientSettings"}, configurationPolicy=ConfigurationPolicy.REQUIRE, service={OAuth2Service.class}, property={"clientName={clientName}"})
@Designate(ocd=OAuth2ClientSettings.class, factory=true)
public class OAuth2ClientManager
implements OAuth2Service {
    private OAuth2ClientSettings _settings;
    private OAuth2Service _service;

    @Activate
    public void activate(OAuth2ClientSettings settings) {
        this._settings = new OAuth2ClientSettingsProxy(settings);
        this._service = new OAuth2ClientService(this._settings, OAuth2TokenCache.of(this._settings.cacheMaxEntries()));
    }

    @Override
    public String getAccessToken() {
        return this._service.getAccessToken();
    }
}

