/*
 * Decompiled with CFR 0.152.
 */
package smartadapter.internal.mapper;

import android.util.SparseArray;
import android.view.ViewGroup;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import smartadapter.SmartRecyclerAdapter;
import smartadapter.internal.mapper.ViewHolderConstructorMapper;
import smartadapter.internal.utils.ReflectionUtils;
import smartadapter.listener.ViewEventListener;
import smartadapter.viewholder.SmartAdapterHolder;
import smartadapter.viewholder.SmartViewHolder;
import smartadapter.viewholder.ViewEventHolder;
import smartadapter.widget.ViewTypeResolver;

public class ViewHolderMapper {
    private final Object caller;
    private int identifier = 0;
    private final SparseArray<Class<? extends SmartViewHolder>> viewTypeMapper = new SparseArray();
    private final ViewHolderConstructorMapper viewHolderConstructorMapper = new ViewHolderConstructorMapper();
    private HashMap<String, Class<? extends SmartViewHolder>> dataTypeViewHolderMapper = new HashMap();
    private HashMap<Class<? extends SmartViewHolder>, SmartRecyclerAdapter> smartRecyclerAdapterMapper = new HashMap();

    public ViewHolderMapper(Object callerEnclosingClass) {
        this.caller = callerEnclosingClass;
    }

    public int getItemViewType(ViewTypeResolver viewTypeResolver, Object item, int position) {
        Class<? extends SmartViewHolder> viewHolder;
        Class<? extends SmartViewHolder> clazz = viewHolder = viewTypeResolver == null ? null : viewTypeResolver.getViewType(item, position);
        if (viewHolder == null) {
            viewHolder = this.dataTypeViewHolderMapper.get(item.getClass().getName());
        }
        if (viewHolder != null) {
            if (this.viewTypeMapper.indexOfValue(viewHolder) < 0) {
                this.viewTypeMapper.put(this.identifier++, viewHolder);
            }
            for (int i = 0; i < this.viewTypeMapper.size(); ++i) {
                Class viewType = (Class)this.viewTypeMapper.get(i);
                if (!viewType.getName().equals(viewHolder.getName())) continue;
                return this.viewTypeMapper.keyAt(i);
            }
        }
        throw new RuntimeException(String.format("Fatal error! Mapping of ViewHolder to item '%s' does not exist", item.getClass().getName()));
    }

    public <VH extends SmartViewHolder> VH createViewHolder(HashMap<Class<? extends SmartViewHolder>, HashMap<Integer, HashMap<Integer, ViewEventListener>>> viewEventListeners, ViewGroup parent, int viewType) {
        SmartViewHolder viewHolder;
        Class smartViewHolderClass = (Class)this.viewTypeMapper.get(viewType);
        Constructor constructor = this.viewHolderConstructorMapper.getConstructor(smartViewHolderClass);
        try {
            Object[] objectArray;
            if (ReflectionUtils.isNonStaticInnerClass(smartViewHolderClass)) {
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = this.caller;
                objectArray = objectArray2;
                objectArray2[1] = parent;
            } else {
                Object[] objectArray3 = new Object[1];
                objectArray = objectArray3;
                objectArray3[0] = parent;
            }
            viewHolder = (SmartViewHolder)ReflectionUtils.invokeConstructor(constructor, objectArray);
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Could not invoke constructor for '%s', '%s'", smartViewHolderClass.toString(), e.getMessage()), e);
        }
        if (viewHolder instanceof ViewEventHolder) {
            ((ViewEventHolder)((Object)viewHolder)).setViewEventListeners(viewEventListeners.get(SmartViewHolder.class));
            ((ViewEventHolder)((Object)viewHolder)).setViewEventListeners(viewEventListeners.get(viewHolder.getClass()));
        }
        SmartRecyclerAdapter smartRecyclerAdapter = this.smartRecyclerAdapterMapper.get(viewHolder.getClass());
        if (viewHolder instanceof SmartAdapterHolder && smartRecyclerAdapter != null) {
            ((SmartAdapterHolder)((Object)viewHolder)).setSmartRecyclerAdapter(smartRecyclerAdapter);
        }
        return (VH)viewHolder;
    }

    public void addMapping(Class<?> itemType, Class<? extends SmartViewHolder> viewHolderType) {
        this.dataTypeViewHolderMapper.put(itemType.getName(), viewHolderType);
        this.viewHolderConstructorMapper.add(viewHolderType);
    }

    public void setDataTypeViewHolderMapper(HashMap<String, Class<? extends SmartViewHolder>> dataTypeViewHolderMapper) {
        this.dataTypeViewHolderMapper = dataTypeViewHolderMapper;
        this.viewHolderConstructorMapper.add(dataTypeViewHolderMapper.values());
    }

    public void setSmartRecyclerAdapterMapper(HashMap<Class<? extends SmartViewHolder>, SmartRecyclerAdapter> smartRecyclerAdapterMapper) {
        this.smartRecyclerAdapterMapper = smartRecyclerAdapterMapper;
    }
}

