/*
 * Decompiled with CFR 0.152.
 */
package smartadapter;

import android.support.annotation.NonNull;
import android.support.v7.widget.RecyclerView;
import android.view.ViewGroup;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import smartadapter.ISmartRecyclerAdapter;
import smartadapter.SmartAdapterBuilder;
import smartadapter.internal.mapper.ViewHolderMapper;
import smartadapter.listener.OnViewAttachedToWindowListener;
import smartadapter.listener.OnViewDetachedFromWindowListener;
import smartadapter.listener.ViewEventListener;
import smartadapter.viewholder.RecyclableViewHolder;
import smartadapter.viewholder.SmartViewHolder;
import smartadapter.widget.ViewTypeResolver;

public class SmartRecyclerAdapter
extends RecyclerView.Adapter<SmartViewHolder>
implements ISmartRecyclerAdapter {
    private int itemCount = 0;
    private List items = new ArrayList();
    private final ViewHolderMapper mapper;
    private ViewTypeResolver viewTypeResolver;
    private HashMap<Class<? extends SmartViewHolder>, HashMap<Integer, HashMap<Integer, ViewEventListener>>> viewEventListeners;

    SmartRecyclerAdapter(Object callerEnclosingClass, List items) {
        this.mapper = new ViewHolderMapper(callerEnclosingClass);
        this.setItems(items, false);
        this.updateItemCount();
    }

    public int getItemViewType(int position) {
        return this.mapper.getItemViewType(this.viewTypeResolver, this.items.get(position), position);
    }

    @NonNull
    public SmartViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        return this.mapper.createViewHolder(this.viewEventListeners, parent, viewType);
    }

    public void onBindViewHolder(@NonNull SmartViewHolder holder, int position) {
        holder.bind(this.items.get(position));
    }

    public void onViewRecycled(@NonNull SmartViewHolder holder) {
        super.onViewRecycled((RecyclerView.ViewHolder)holder);
        holder.unbind();
    }

    public boolean onFailedToRecycleView(@NonNull SmartViewHolder holder) {
        if (holder instanceof RecyclableViewHolder) {
            return ((RecyclableViewHolder)((Object)holder)).onFailedToRecycleView();
        }
        return super.onFailedToRecycleView((RecyclerView.ViewHolder)holder);
    }

    public void onViewAttachedToWindow(@NonNull SmartViewHolder holder) {
        super.onViewAttachedToWindow((RecyclerView.ViewHolder)holder);
        if (holder instanceof OnViewAttachedToWindowListener) {
            ((OnViewAttachedToWindowListener)((Object)holder)).onViewAttachedToWindow();
        }
    }

    public void onViewDetachedFromWindow(@NonNull SmartViewHolder holder) {
        super.onViewDetachedFromWindow((RecyclerView.ViewHolder)holder);
        if (holder instanceof OnViewDetachedFromWindowListener) {
            ((OnViewDetachedFromWindowListener)((Object)holder)).onViewDetachedFromWindow();
        }
    }

    @Override
    public int getItemCount() {
        return this.itemCount;
    }

    @Override
    public <T> int getItemCount(Class<T> type) {
        int count = 0;
        for (Object item : this.items) {
            if (!item.getClass().equals(type)) continue;
            ++count;
        }
        return count;
    }

    @Override
    public Object getItem(int index) {
        return this.items.get(index);
    }

    @Override
    public List getItems() {
        return this.items;
    }

    @Override
    public <T> ArrayList<T> getItems(Class<T> type) {
        ArrayList itemOfType = new ArrayList();
        for (Object item : this.items) {
            if (!item.getClass().equals(type)) continue;
            itemOfType.add(item);
        }
        return itemOfType;
    }

    @Override
    public void setItems(List items) {
        this.setItems(items, true);
    }

    @Override
    public void setItems(List items, boolean notifyDataSetChanged) {
        if (items != null) {
            this.items = items;
            if (notifyDataSetChanged) {
                this.smartNotifyDataSetChanged();
            }
        }
    }

    @Override
    public void addItem(Object item) {
        this.addItem(item, true);
    }

    @Override
    public void addItem(Object item, boolean notifyDataSetChanged) {
        if (item != null) {
            this.items.add(item);
            if (notifyDataSetChanged) {
                this.smartNotifyDataSetChanged();
            }
        }
    }

    @Override
    public void addItem(int index, Object item) {
        this.addItem(index, item, true);
    }

    @Override
    public void addItem(int index, Object item, boolean notifyDataSetChanged) {
        if (item != null) {
            this.items.add(index, item);
            if (notifyDataSetChanged) {
                this.smartNotifyItemInserted(index);
            }
        }
    }

    @Override
    public void addItems(List items) {
        this.addItems(items, true);
    }

    @Override
    public void addItems(List items, boolean notifyDataSetChanged) {
        if (items != null) {
            this.items.addAll(items);
            if (notifyDataSetChanged) {
                this.smartNotifyItemRangeInserted(this.getItemCount(), items.size());
            }
        }
    }

    @Override
    public void addItems(int index, List items) {
        this.addItems(index, items, true);
    }

    @Override
    public void addItems(int index, List items, boolean notifyDataSetChanged) {
        if (items != null) {
            this.items.addAll(index, items);
            if (notifyDataSetChanged) {
                this.smartNotifyItemRangeInserted(index, items.size());
            }
        }
    }

    @Override
    public boolean removeItem(int index) {
        return this.removeItem(index, true);
    }

    @Override
    public boolean removeItem(int index, boolean notifyDataSetChanged) {
        if (this.items != null && !this.items.isEmpty()) {
            this.items.remove(index);
            if (notifyDataSetChanged) {
                this.smartNotifyItemRemoved(index);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean replaceItem(int index, Object item) {
        return this.replaceItem(index, item, true);
    }

    @Override
    public boolean replaceItem(int index, Object item, boolean notifyDataSetChanged) {
        if (item != null) {
            this.items.set(index, item);
            if (notifyDataSetChanged) {
                this.smartNotifyItemChanged(index);
            }
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        this.items.clear();
        this.smartNotifyDataSetChanged();
    }

    @Override
    public void smartNotifyDataSetChanged() {
        this.updateItemCount();
        this.notifyDataSetChanged();
    }

    @Override
    public void smartNotifyItemChanged(int position) {
        this.updateItemCount();
        this.notifyItemChanged(position);
    }

    @Override
    public void smartNotifyItemRangeChanged(int positionStart, int itemCount) {
        this.updateItemCount();
        this.notifyItemRangeChanged(positionStart, itemCount);
    }

    @Override
    public void smartNotifyItemInserted(int position) {
        this.updateItemCount();
        this.notifyItemInserted(position);
    }

    @Override
    public void smartNotifyItemRangeInserted(int positionStart, int itemCount) {
        this.updateItemCount();
        this.notifyItemRangeInserted(positionStart, itemCount);
    }

    @Override
    public void smartNotifyItemRemoved(int position) {
        this.updateItemCount();
        this.notifyItemRemoved(position);
    }

    @Override
    public void smartNotifyItemRangeRemoved(int positionStart, int itemCount) {
        this.updateItemCount();
        this.notifyItemRangeRemoved(positionStart, itemCount);
    }

    @Override
    public final void updateItemCount() {
        this.itemCount = this.items.size();
    }

    @Override
    public void map(Class<?> itemType, Class<? extends SmartViewHolder> viewHolderType) {
        this.mapper.addMapping(itemType, viewHolderType);
    }

    @Override
    public ViewHolderMapper getMapper() {
        return this.mapper;
    }

    void setDataTypeViewHolderMapper(HashMap<String, Class<? extends SmartViewHolder>> dataTypeViewHolderMapper) {
        this.mapper.setDataTypeViewHolderMapper(dataTypeViewHolderMapper);
    }

    void setSmartRecyclerAdapterMapper(HashMap<Class<? extends SmartViewHolder>, SmartRecyclerAdapter> smartRecyclerAdapterMapper) {
        this.mapper.setSmartRecyclerAdapterMapper(smartRecyclerAdapterMapper);
    }

    @Override
    public ViewTypeResolver getViewTypeResolver() {
        return this.viewTypeResolver;
    }

    @Override
    public void setViewTypeResolver(ViewTypeResolver viewTypeResolver) {
        this.viewTypeResolver = viewTypeResolver;
    }

    @Override
    public HashMap<Class<? extends SmartViewHolder>, HashMap<Integer, HashMap<Integer, ViewEventListener>>> getViewEventListeners() {
        return this.viewEventListeners;
    }

    @Override
    public HashMap<Integer, HashMap<Integer, ViewEventListener>> getViewEventListenersForViewHolder(Class<? extends SmartViewHolder> viewHolderType) {
        return this.getViewEventListeners().get(viewHolderType);
    }

    @Override
    public void setViewEventListeners(HashMap<Class<? extends SmartViewHolder>, HashMap<Integer, HashMap<Integer, ViewEventListener>>> viewEventListeners) {
        this.viewEventListeners = viewEventListeners;
    }

    public static SmartAdapterBuilder items(List items) {
        return new SmartAdapterBuilder(new SmartRecyclerAdapter(null, items));
    }

    public static SmartAdapterBuilder empty() {
        return new SmartAdapterBuilder(new SmartRecyclerAdapter(null, new ArrayList()));
    }
}

