/*
 * Decompiled with CFR 0.152.
 */
package smartadapter;

import android.support.annotation.LayoutRes;
import android.support.annotation.NonNull;
import android.view.View;
import android.view.ViewGroup;
import java.util.ArrayList;
import java.util.List;
import smartadapter.ISmartEndlessScrollRecyclerAdapter;
import smartadapter.R;
import smartadapter.SmartAdapterBuilder;
import smartadapter.SmartRecyclerAdapter;
import smartadapter.listener.OnLoadMoreListener;
import smartadapter.viewholder.LoadMoreViewHolder;
import smartadapter.viewholder.SmartViewHolder;

public class SmartEndlessScrollRecyclerAdapter
extends SmartRecyclerAdapter
implements ISmartEndlessScrollRecyclerAdapter {
    private final int VIEW_TYPE_LOADING = Integer.MAX_VALUE;
    private OnLoadMoreListener onLoadMoreListener;
    private boolean endlessScrollEnabled = true;
    private boolean loading = false;
    private int loadMoreLayoutResource = R.layout.loadmore_view;

    SmartEndlessScrollRecyclerAdapter(Object callerEnclosingClass, @NonNull List items) {
        super(callerEnclosingClass, items);
    }

    @Override
    public int getItemViewType(int position) {
        if (this.isEndlessScrollEnabled() && position == this.getItemCount() - this.getEndlessScrollOffset()) {
            return Integer.MAX_VALUE;
        }
        return super.getItemViewType(position);
    }

    @Override
    @NonNull
    public SmartViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        if (viewType == Integer.MAX_VALUE) {
            return new LoadMoreViewHolder((View)parent, this.loadMoreLayoutResource);
        }
        return super.onCreateViewHolder(parent, viewType);
    }

    @Override
    public void onBindViewHolder(@NonNull SmartViewHolder holder, int position) {
        if (position < this.getItemCount() - this.getEndlessScrollOffset()) {
            super.onBindViewHolder(holder, position);
        }
    }

    @Override
    public int getItemCount() {
        return super.getItemCount() + this.getEndlessScrollOffset();
    }

    @Override
    public void onViewAttachedToWindow(@NonNull SmartViewHolder holder) {
        super.onViewAttachedToWindow(holder);
        if (holder instanceof LoadMoreViewHolder) {
            this.onLoadMoreListener.onLoadMore();
        }
    }

    @Override
    public int getEndlessScrollOffset() {
        return this.isEndlessScrollEnabled() ? 1 : 0;
    }

    @Override
    public boolean isEndlessScrollEnabled() {
        return this.endlessScrollEnabled;
    }

    @Override
    public void setEndlessScrollEnabled(boolean enabled) {
        this.endlessScrollEnabled = enabled;
        this.smartNotifyDataSetChanged();
    }

    @Override
    public boolean isLoading() {
        return this.loading;
    }

    @Override
    public void setIsLoading(boolean loading) {
        this.loading = loading;
    }

    @Override
    public void setOnLoadMoreListener(@NonNull OnLoadMoreListener onLoadMoreListener) {
        this.onLoadMoreListener = onLoadMoreListener;
    }

    @Override
    public void setCustomLoadMoreLayoutResource(@LayoutRes int loadMoreLayoutResource) {
        this.loadMoreLayoutResource = loadMoreLayoutResource;
    }

    public static SmartAdapterBuilder items(List items) {
        return new SmartAdapterBuilder(new SmartEndlessScrollRecyclerAdapter(null, items));
    }

    public static SmartAdapterBuilder empty() {
        return new SmartAdapterBuilder(new SmartEndlessScrollRecyclerAdapter(null, new ArrayList()));
    }
}

