/*
 * Decompiled with CFR 0.152.
 */
package smartadapter;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import java.util.HashMap;
import smartadapter.R;
import smartadapter.SmartRecyclerAdapter;
import smartadapter.internal.utils.ViewEventValidator;
import smartadapter.listener.ViewEventListener;
import smartadapter.viewholder.SmartAutoEventViewHolder;
import smartadapter.viewholder.SmartViewHolder;
import smartadapter.widget.ViewTypeResolver;

public class SmartAdapterBuilder {
    private RecyclerView.LayoutManager layoutManager;
    private ViewTypeResolver viewTypeResolver;
    private HashMap<String, Class<? extends SmartViewHolder>> viewHolderMapper = new HashMap();
    private HashMap<Class<? extends SmartViewHolder>, SmartRecyclerAdapter> smartRecyclerAdapterMapper = new HashMap();
    private HashMap<Class<? extends SmartViewHolder>, HashMap<Integer, HashMap<Integer, ViewEventListener>>> viewEventListenerMap = new HashMap();
    private SmartRecyclerAdapter smartRecyclerAdapter;

    SmartAdapterBuilder(@NonNull SmartRecyclerAdapter smartRecyclerAdapter) {
        this.smartRecyclerAdapter = smartRecyclerAdapter;
    }

    public final SmartAdapterBuilder map(Class<?> itemType, Class<? extends SmartViewHolder> viewHolderType) {
        this.viewHolderMapper.put(itemType.getName(), viewHolderType);
        return this;
    }

    public final SmartAdapterBuilder map(Class<? extends SmartViewHolder> viewHolderType, SmartRecyclerAdapter smartRecyclerAdapter) {
        this.smartRecyclerAdapterMapper.put(viewHolderType, smartRecyclerAdapter);
        return this;
    }

    public final SmartAdapterBuilder setLayoutManager(RecyclerView.LayoutManager layoutManager) {
        this.layoutManager = layoutManager;
        return this;
    }

    private RecyclerView.LayoutManager getLayoutManager(Context context) {
        if (this.layoutManager == null) {
            this.layoutManager = new LinearLayoutManager(context);
        }
        return this.layoutManager;
    }

    public final SmartAdapterBuilder setViewTypeResolver(ViewTypeResolver viewTypeResolver) {
        this.viewTypeResolver = viewTypeResolver;
        return this;
    }

    public final SmartAdapterBuilder addViewEventListener(ViewEventListener viewEventListener) {
        return this.addViewEventListener(SmartViewHolder.class, R.id.undefined, R.id.undefined, viewEventListener);
    }

    public final SmartAdapterBuilder addViewEventListener(ViewEventListener viewEventListener, int autoViewEventId) {
        return this.addViewEventListener(SmartViewHolder.class, R.id.undefined, autoViewEventId, viewEventListener);
    }

    public final SmartAdapterBuilder addViewEventListener(int autoViewEventId, ViewEventListener viewEventListener) {
        return this.addViewEventListener(SmartViewHolder.class, R.id.undefined, autoViewEventId, viewEventListener);
    }

    public final SmartAdapterBuilder addViewEventListener(Class<? extends SmartViewHolder> viewHolderType, ViewEventListener viewEventListener) {
        return this.addViewEventListener(viewHolderType, R.id.undefined, R.id.undefined, viewEventListener);
    }

    public final SmartAdapterBuilder addViewEventListener(Class<? extends SmartViewHolder> viewHolderType, int autoViewEventId, ViewEventListener viewEventListener) {
        return this.addViewEventListener(viewHolderType, R.id.undefined, autoViewEventId, viewEventListener);
    }

    public final SmartAdapterBuilder addViewEventListener(Class<? extends SmartViewHolder> viewHolderType, int viewId, int autoViewEventId, ViewEventListener viewEventListener) {
        if (!ViewEventValidator.isViewEventIdValid(autoViewEventId)) {
            throw new RuntimeException(String.format("Invalid view event id (%d) for ViewHolder (%s)", autoViewEventId, viewHolderType));
        }
        if (autoViewEventId != R.id.undefined && ViewEventValidator.isViewEventIdValid(autoViewEventId) && !viewHolderType.equals(SmartViewHolder.class) && !SmartAutoEventViewHolder.class.isAssignableFrom(viewHolderType)) {
            throw new RuntimeException(String.format("View event id (%d) set but ViewHolder (%s) is not assignable from SmartAutoEventViewHolder", autoViewEventId, viewHolderType));
        }
        HashMap<Integer, HashMap<Integer, ViewEventListener>> mapper = this.viewEventListenerMap.get(viewHolderType);
        if (mapper == null) {
            mapper = new HashMap();
        }
        if (!mapper.containsKey(viewId)) {
            HashMap<Integer, ViewEventListener> viewEventAndListenerMap = new HashMap<Integer, ViewEventListener>();
            viewEventAndListenerMap.put(autoViewEventId, viewEventListener);
            mapper.put(viewId, viewEventAndListenerMap);
        }
        mapper.get(viewId).put(autoViewEventId, viewEventListener);
        this.viewEventListenerMap.put(viewHolderType, mapper);
        return this;
    }

    public final <T> T into(RecyclerView recyclerView) {
        this.smartRecyclerAdapter.setDataTypeViewHolderMapper(this.viewHolderMapper);
        this.smartRecyclerAdapter.setSmartRecyclerAdapterMapper(this.smartRecyclerAdapterMapper);
        this.smartRecyclerAdapter.setViewTypeResolver(this.viewTypeResolver);
        this.smartRecyclerAdapter.setViewEventListeners(this.viewEventListenerMap);
        recyclerView.setAdapter((RecyclerView.Adapter)this.smartRecyclerAdapter);
        recyclerView.setLayoutManager(this.getLayoutManager(recyclerView.getContext()));
        return (T)this.smartRecyclerAdapter;
    }

    public final <T> T create() {
        this.smartRecyclerAdapter.setDataTypeViewHolderMapper(this.viewHolderMapper);
        this.smartRecyclerAdapter.setSmartRecyclerAdapterMapper(this.smartRecyclerAdapterMapper);
        this.smartRecyclerAdapter.setViewTypeResolver(this.viewTypeResolver);
        this.smartRecyclerAdapter.setViewEventListeners(this.viewEventListenerMap);
        return (T)this.smartRecyclerAdapter;
    }
}

