/*
 * Decompiled with CFR 0.152.
 */
package io.github.majusko.grpc.apm.interceptor;

import co.elastic.apm.opentracing.ElasticApmTags;
import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.opentracing.Scope;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.propagation.Format;
import io.opentracing.propagation.TextMapAdapter;
import io.opentracing.tag.Tag;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;

@Component
public class GrpcTracer {
    private static final String APM_TYPE = "request";
    private final Tracer elasticApmTracer;

    public GrpcTracer(Tracer elasticApmTracer) {
        this.elasticApmTracer = elasticApmTracer;
    }

    public Span trace(ServerCall<?, ?> call, Metadata headers) {
        String spanName = call.getMethodDescriptor().getFullMethodName();
        SpanContext parentContext = this.elasticApmTracer.extract(Format.Builtin.HTTP_HEADERS, (Object)GrpcTracer.parseHeaders(headers));
        Span span = this.elasticApmTracer.buildSpan(spanName).asChildOf(parentContext).withTag((Tag)ElasticApmTags.TYPE, (Object)APM_TYPE).start();
        this.activate(span);
        return span;
    }

    public Scope activate(Span span) {
        return this.elasticApmTracer.activateSpan(span);
    }

    private static TextMapAdapter parseHeaders(Metadata headers) {
        return new TextMapAdapter(headers.keys().stream().filter($ -> !$.endsWith("-bin")).map($ -> Metadata.Key.of((String)$, (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER)).filter(arg_0 -> ((Metadata)headers).containsKey(arg_0)).collect(Collectors.toMap(Metadata.Key::originalName, arg_0 -> ((Metadata)headers).get(arg_0))));
    }
}

