/*
 * Decompiled with CFR 0.152.
 */
package io.github.majusko.grpc.apm.interceptor;

import io.github.majusko.grpc.apm.interceptor.GrpcApmContext;
import io.github.majusko.grpc.apm.interceptor.GrpcTracer;
import io.grpc.Context;
import io.grpc.Contexts;
import io.grpc.ForwardingServerCallListener;
import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import io.opentracing.Scope;
import io.opentracing.Span;
import org.lognet.springboot.grpc.GRpcGlobalInterceptor;

@GRpcGlobalInterceptor
public class ApmServerInterceptor
implements ServerInterceptor {
    private final GrpcTracer grpcTracer;

    public ApmServerInterceptor(GrpcTracer grpcTracer) {
        this.grpcTracer = grpcTracer;
    }

    public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> call, Metadata metadata, ServerCallHandler<ReqT, RespT> next) {
        Span span = this.grpcTracer.trace(call, metadata);
        Context context = Context.current().withValue(GrpcApmContext.ACTIVE_SPAN_KEY, (Object)span);
        return this.buildListener(call, metadata, next, context, span);
    }

    private <ReqT, RespT> ForwardingServerCallListener.SimpleForwardingServerCallListener<ReqT> buildListener(ServerCall<ReqT, RespT> call, Metadata metadata, ServerCallHandler<ReqT, RespT> next, Context context, final Span span) {
        ServerCall.Listener customDelegate = Contexts.interceptCall((Context)context, call, (Metadata)metadata, next);
        return new ForwardingServerCallListener.SimpleForwardingServerCallListener<ReqT>(customDelegate){

            public void onMessage(ReqT request) {
                try (Scope ignored = ApmServerInterceptor.this.grpcTracer.activate(span);){
                    super.onMessage(request);
                }
            }

            public void onHalfClose() {
                try (Scope ignored = ApmServerInterceptor.this.grpcTracer.activate(span);){
                    super.onHalfClose();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onCancel() {
                try (Scope ignored = ApmServerInterceptor.this.grpcTracer.activate(span);){
                    super.onCancel();
                }
                finally {
                    span.finish();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onComplete() {
                try (Scope ignored = ApmServerInterceptor.this.grpcTracer.activate(span);){
                    super.onComplete();
                }
                finally {
                    span.finish();
                }
            }

            public void onReady() {
                try (Scope ignored = ApmServerInterceptor.this.grpcTracer.activate(span);){
                    super.onReady();
                }
            }
        };
    }
}

