/*
 * Decompiled with CFR 0.152.
 */
package io.github.majusko.grpc.apm.interceptor;

import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ForwardingClientCall;
import io.grpc.ForwardingClientCallListener;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import io.opentracing.Scope;
import io.opentracing.Span;
import io.opentracing.Tracer;
import io.opentracing.propagation.Format;
import io.opentracing.propagation.TextMap;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nullable;

public class ApmClientInterceptor
implements ClientInterceptor {
    private final Tracer elasticApmTracer;

    public ApmClientInterceptor(Tracer elasticApmTracer) {
        this.elasticApmTracer = elasticApmTracer;
    }

    private TextMap addHeaders(final Metadata headers) {
        return new TextMap(){

            public void put(String key, String value) {
                Metadata.Key headerKey = Metadata.Key.of((String)key, (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
                headers.put(headerKey, (Object)value);
            }

            public Iterator<Map.Entry<String, String>> iterator() {
                throw new UnsupportedOperationException("TextMapAdapter should only be used with Tracer.inject()");
            }
        };
    }

    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
        String operationName = method.getFullMethodName();
        final Span span = this.elasticApmTracer.buildSpan(operationName).asChildOf(this.elasticApmTracer.activeSpan()).start();
        try (Scope ignored = this.elasticApmTracer.activateSpan(span);){
            ForwardingClientCall.SimpleForwardingClientCall simpleForwardingClientCall = new ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT>(next.newCall(method, callOptions)){

                public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
                    ApmClientInterceptor.this.elasticApmTracer.inject(span.context(), Format.Builtin.HTTP_HEADERS, (Object)ApmClientInterceptor.this.addHeaders(headers));
                    ForwardingClientCallListener.SimpleForwardingClientCallListener tracingResponseListener = new ForwardingClientCallListener.SimpleForwardingClientCallListener<RespT>(responseListener){

                        public void onClose(Status status, Metadata metadata) {
                            super.onClose(status, metadata);
                            span.finish();
                        }
                    };
                    try (Scope ignored = ApmClientInterceptor.this.elasticApmTracer.scopeManager().activate(span);){
                        super.start((ClientCall.Listener)tracingResponseListener, headers);
                    }
                }

                public void sendMessage(ReqT message) {
                    try (Scope ignored = ApmClientInterceptor.this.elasticApmTracer.scopeManager().activate(span);){
                        super.sendMessage(message);
                    }
                }

                public void halfClose() {
                    try (Scope ignored = ApmClientInterceptor.this.elasticApmTracer.scopeManager().activate(span);){
                        super.halfClose();
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void cancel(@Nullable String message, @Nullable Throwable cause) {
                    try (Scope ignored = ApmClientInterceptor.this.elasticApmTracer.scopeManager().activate(span);){
                        super.cancel(message, cause);
                    }
                    finally {
                        span.finish();
                    }
                }
            };
            return simpleForwardingClientCall;
        }
    }
}

