/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.server.model.federation.edu.content;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.github.ma1uta.matrix.Id;
import io.github.ma1uta.matrix.event.content.RoomMessageContent;
import io.github.ma1uta.matrix.server.model.federation.edu.content.EphemeralDataUnitContent;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Map;
import javax.json.bind.annotation.JsonbProperty;

@Schema(description="Direct device message content.")
public class ToDeviceMessageContent
implements EphemeralDataUnitContent {
    @Schema(description="User ID of the sender.", required=true)
    private Id sender;
    @Schema(description="Event type for the message.", required=true)
    private String type;
    @Schema(name="message_id", description="Unique ID for the message, used for idempotence. Arbitrary utf8 string, of maximum length 32 codepoints.", required=true)
    @JsonbProperty(value="message_id")
    private String messageId;
    @Schema(description="The contents of the messages to be sent. These are arranged in a map of user IDs to a map of device IDs to message bodies. The device ID may also be *, meaning all known devices for the user.", required=true)
    private Map<Id, Map<String, RoomMessageContent>> messages;

    public Id getSender() {
        return this.sender;
    }

    public void setSender(Id sender) {
        this.sender = sender;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @JsonProperty(value="message_id")
    public String getMessageId() {
        return this.messageId;
    }

    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    public Map<Id, Map<String, RoomMessageContent>> getMessages() {
        return this.messages;
    }

    public void setMessages(Map<Id, Map<String, RoomMessageContent>> messages) {
        this.messages = messages;
    }
}

