/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.server.api;

import io.github.ma1uta.matrix.server.model.key.KeyResponse;
import io.github.ma1uta.matrix.server.model.key.QueryRequest;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.UriInfo;

@Path(value="/_matrix/key/v2")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public interface KeyApi {
    @Operation(summary="Gets the homeserver's published TLS fingerprints and signing keys.", responses={@ApiResponse(responseCode="200", description="The homeservers's keys.", content={@Content(schema=@Schema(implementation=KeyResponse.class))})})
    @GET
    @Path(value="/server/{keyId}")
    public void key(@Parameter(name="keyId", description="Servers should not use this parameter and instead opt to return all keys, not just the requested one. The key ID to look up.", deprecated=true) @PathParam(value="keyId") String var1, @Context UriInfo var2, @Context HttpHeaders var3, @Suspended AsyncResponse var4);

    @Operation(summary="Query for another server's keys. The receiving (notary) server must sign the keys returned by the queried server.", responses={@ApiResponse(responseCode="200", description="The keys for the server, or an empty array if the server could not be reached and no cached keys were available.", content={@Content(schema=@Schema(implementation=KeyResponse.class))})})
    @GET
    @Path(value="/query/{serverName}/{keyId}")
    public void query(@Parameter(name="serverName", description="The server's DNS name to query", required=true) @PathParam(value="serverName") String var1, @Parameter(name="keyId", description="Servers should not use this parameter and instead opt to return all keys, not just the requested one.The key ID to look up.", deprecated=true) @PathParam(value="keyId") String var2, @Parameter(name="minimumValidUntilTs", description="A millisecond POSIX timestamp in milliseconds indicating when the returned certificates will need to be valid until to be useful to the requesting server.") @QueryParam(value="minimumValidUntilTs") Long var3, @Context UriInfo var4, @Context HttpHeaders var5, @Suspended AsyncResponse var6);

    @Operation(summary="Query for another server's keys. The receiving (notary) server must sign the keys returned by the queried server.", responses={@ApiResponse(responseCode="200", description="The keys for the server, or an empty array if the server could not be reached and no cached keys were available.", content={@Content(schema=@Schema(implementation=KeyResponse.class))})})
    @POST
    @Path(value="/query")
    public void bulkQuery(@RequestBody(description="Bulk query request.") QueryRequest var1, @Context UriInfo var2, @Context HttpHeaders var3, @Suspended AsyncResponse var4);
}

