/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.server.model.federation.edu.content.nested;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import javax.json.bind.annotation.JsonbProperty;

@Schema(description="User presence update.")
public class UserPresenceUpdate {
    @Schema(name="user_id", description="The user ID this presence EDU is for.", required=true)
    @JsonbProperty(value="user_id")
    private String userId;
    @Schema(description="The presence of the user.", required=true, allowableValues={"offline", "unavailable", "online"})
    private String presence;
    @Schema(name="status_msg", description="An optional description to accompany the presence.")
    @JsonbProperty(value="status_msg")
    private String statusMsg;
    @Schema(name="last_active_ago", description="The number of milliseconds that have elapsed since the user last did something.", required=true)
    @JsonbProperty(value="last_active_ago")
    private Long lastActiveAgo;
    @Schema(name="currently_active", description="True if the user is likely to be interacting with their client. This may be indicated by the user having a last_active_ago within the last few minutes.", defaultValue="false")
    @JsonbProperty(value="currently_active")
    private Boolean currentlyActive;

    @JsonProperty(value="user_id")
    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getPresence() {
        return this.presence;
    }

    public void setPresence(String presence) {
        this.presence = presence;
    }

    @JsonProperty(value="status_msg")
    public String getStatusMsg() {
        return this.statusMsg;
    }

    public void setStatusMsg(String statusMsg) {
        this.statusMsg = statusMsg;
    }

    @JsonProperty(value="last_active_ago")
    public Long getLastActiveAgo() {
        return this.lastActiveAgo;
    }

    public void setLastActiveAgo(Long lastActiveAgo) {
        this.lastActiveAgo = lastActiveAgo;
    }

    @JsonProperty(value="currently_active")
    public Boolean getCurrentlyActive() {
        return this.currentlyActive;
    }

    public void setCurrentlyActive(Boolean currentlyActive) {
        this.currentlyActive = currentlyActive;
    }

    public static class Presence {
        public static final String OFFLINE = "offline";
        public static final String UNAVAILABLE = "unavailable";
        public static final String ONLINE = "online";

        protected Presence() {
        }
    }
}

