/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.support.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import io.github.ma1uta.matrix.event.content.RoomMessageContent;
import io.github.ma1uta.matrix.event.message.Audio;
import io.github.ma1uta.matrix.event.message.Emote;
import io.github.ma1uta.matrix.event.message.File;
import io.github.ma1uta.matrix.event.message.Image;
import io.github.ma1uta.matrix.event.message.Location;
import io.github.ma1uta.matrix.event.message.Notice;
import io.github.ma1uta.matrix.event.message.RawMessageContent;
import io.github.ma1uta.matrix.event.message.ServerNotice;
import io.github.ma1uta.matrix.event.message.Text;
import io.github.ma1uta.matrix.event.message.Video;
import java.io.IOException;

public class RoomMessageContentDeserializer
extends JsonDeserializer<RoomMessageContent> {
    public RoomMessageContent deserialize(JsonParser parser, DeserializationContext ctxt) throws IOException {
        String msgtype;
        ObjectCodec codec = parser.getCodec();
        JsonNode node = (JsonNode)codec.readTree(parser);
        if (node == null) {
            return null;
        }
        JsonNode typeNode = node.get("msgtype");
        if (typeNode == null || !typeNode.isTextual()) {
            return this.parse(node, ctxt, codec, null);
        }
        switch (msgtype = typeNode.asText()) {
            case "m.audio": {
                return (RoomMessageContent)codec.treeToValue((TreeNode)node, Audio.class);
            }
            case "m.emote": {
                return (RoomMessageContent)codec.treeToValue((TreeNode)node, Emote.class);
            }
            case "m.file": {
                return (RoomMessageContent)codec.treeToValue((TreeNode)node, File.class);
            }
            case "m.image": {
                return (RoomMessageContent)codec.treeToValue((TreeNode)node, Image.class);
            }
            case "m.location": {
                return (RoomMessageContent)codec.treeToValue((TreeNode)node, Location.class);
            }
            case "m.notice": {
                return (RoomMessageContent)codec.treeToValue((TreeNode)node, Notice.class);
            }
            case "m.text": {
                return (RoomMessageContent)codec.treeToValue((TreeNode)node, Text.class);
            }
            case "m.video": {
                return (RoomMessageContent)codec.treeToValue((TreeNode)node, Video.class);
            }
            case "m.server_notice": {
                return (RoomMessageContent)codec.treeToValue((TreeNode)node, ServerNotice.class);
            }
        }
        return this.parse(node, ctxt, codec, msgtype);
    }

    protected RoomMessageContent parse(JsonNode jsonNode, DeserializationContext ctxt, ObjectCodec codec, String msgtype) {
        return new RawMessageContent((Object)jsonNode, msgtype);
    }
}

