/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.support.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import io.github.ma1uta.matrix.event.content.RoomEncryptedContent;
import io.github.ma1uta.matrix.event.encrypted.MegolmEncryptedContent;
import io.github.ma1uta.matrix.event.encrypted.OlmEncryptedContent;
import io.github.ma1uta.matrix.event.encrypted.RawEncryptedContent;
import java.io.IOException;

public class RoomEncryptedContentDeserializer
extends JsonDeserializer<RoomEncryptedContent> {
    public RoomEncryptedContent deserialize(JsonParser parser, DeserializationContext ctxt) throws IOException {
        String algorithm;
        ObjectCodec codec = parser.getCodec();
        JsonNode node = (JsonNode)codec.readTree(parser);
        JsonNode algorithmNode = node.get("algorithm");
        if (algorithmNode == null || !algorithmNode.isTextual()) {
            return this.parse(node, ctxt, codec, null);
        }
        switch (algorithm = algorithmNode.asText()) {
            case "m.megolm.v1.aes-sha2": {
                return (RoomEncryptedContent)codec.treeToValue((TreeNode)node, MegolmEncryptedContent.class);
            }
            case "m.olm.v1.curve25519-aes-sha2": {
                return (RoomEncryptedContent)codec.treeToValue((TreeNode)node, OlmEncryptedContent.class);
            }
        }
        return this.parse(node, ctxt, codec, algorithm);
    }

    protected RoomEncryptedContent parse(JsonNode jsonNode, DeserializationContext ctxt, ObjectCodec codec, String algorithm) {
        return new RawEncryptedContent((Object)jsonNode, algorithm);
    }
}

