/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.support.jackson;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import io.github.ma1uta.matrix.event.Event;
import io.github.ma1uta.matrix.event.content.RoomEncryptedContent;
import io.github.ma1uta.matrix.event.content.RoomMessageContent;
import io.github.ma1uta.matrix.support.jackson.EventDeserializer;
import io.github.ma1uta.matrix.support.jackson.RoomEncryptedContentDeserializer;
import io.github.ma1uta.matrix.support.jackson.RoomMessageContentDeserializer;
import javax.ws.rs.Produces;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.Provider;

@Provider
@Produces(value={"application/json"})
public class JacksonContextResolver
implements ContextResolver<ObjectMapper> {
    private ObjectMapper mapper;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ObjectMapper getContext(Class<?> type) {
        if (this.mapper != null) return this.mapper;
        Class<JacksonContextResolver> clazz = JacksonContextResolver.class;
        synchronized (JacksonContextResolver.class) {
            if (this.mapper != null) return this.mapper;
            this.mapper = new ObjectMapper();
            this.mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
            this.mapper.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
            this.mapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
            SimpleModule eventModule = new SimpleModule("Matrix Event Module");
            eventModule.addDeserializer(Event.class, (JsonDeserializer)new EventDeserializer());
            eventModule.addDeserializer(RoomEncryptedContent.class, (JsonDeserializer)new RoomEncryptedContentDeserializer());
            eventModule.addDeserializer(RoomMessageContent.class, (JsonDeserializer)new RoomMessageContentDeserializer());
            this.mapper.registerModule((Module)eventModule);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return this.mapper;
        }
    }
}

