/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.support.jackson;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.github.ma1uta.matrix.event.content.CallAnswerContent;
import io.github.ma1uta.matrix.event.content.CallCandidatesContent;
import io.github.ma1uta.matrix.event.content.CallHangupContent;
import io.github.ma1uta.matrix.event.content.CallInviteContent;
import io.github.ma1uta.matrix.event.content.DirectContent;
import io.github.ma1uta.matrix.event.content.EventContent;
import io.github.ma1uta.matrix.event.content.ForwardedRoomKeyContent;
import io.github.ma1uta.matrix.event.content.FullyReadContent;
import io.github.ma1uta.matrix.event.content.IgnoredUserListContent;
import io.github.ma1uta.matrix.event.content.PresenceContent;
import io.github.ma1uta.matrix.event.content.RawEventContent;
import io.github.ma1uta.matrix.event.content.ReceiptContent;
import io.github.ma1uta.matrix.event.content.RoomAliasesContent;
import io.github.ma1uta.matrix.event.content.RoomAvatarContent;
import io.github.ma1uta.matrix.event.content.RoomCanonicalAliasContent;
import io.github.ma1uta.matrix.event.content.RoomCreateContent;
import io.github.ma1uta.matrix.event.content.RoomEncryptedContent;
import io.github.ma1uta.matrix.event.content.RoomEncryptionContent;
import io.github.ma1uta.matrix.event.content.RoomGuestAccessContent;
import io.github.ma1uta.matrix.event.content.RoomHistoryVisibilityContent;
import io.github.ma1uta.matrix.event.content.RoomJoinRulesContent;
import io.github.ma1uta.matrix.event.content.RoomKeyContent;
import io.github.ma1uta.matrix.event.content.RoomKeyRequestContent;
import io.github.ma1uta.matrix.event.content.RoomMemberContent;
import io.github.ma1uta.matrix.event.content.RoomMessageContent;
import io.github.ma1uta.matrix.event.content.RoomMessageFeedbackContent;
import io.github.ma1uta.matrix.event.content.RoomNameContent;
import io.github.ma1uta.matrix.event.content.RoomPinnedContent;
import io.github.ma1uta.matrix.event.content.RoomPowerLevelsContent;
import io.github.ma1uta.matrix.event.content.RoomRedactionContent;
import io.github.ma1uta.matrix.event.content.RoomServerAclContent;
import io.github.ma1uta.matrix.event.content.RoomThirdPartyInviteContent;
import io.github.ma1uta.matrix.event.content.RoomTopicContent;
import io.github.ma1uta.matrix.event.content.StickerContent;
import io.github.ma1uta.matrix.event.content.TagContent;
import io.github.ma1uta.matrix.event.content.TypingContent;
import java.io.IOException;
import java.util.Map;

public class EventContentDeserializer {
    public EventContent deserialize(byte[] content, String type, ObjectMapper mapper) throws IOException {
        switch (type) {
            case "m.call.answer": {
                return (EventContent)mapper.readValue(content, CallAnswerContent.class);
            }
            case "m.call.candidates": {
                return (EventContent)mapper.readValue(content, CallCandidatesContent.class);
            }
            case "m.call.hangup": {
                return (EventContent)mapper.readValue(content, CallHangupContent.class);
            }
            case "m.call.invite": {
                return (EventContent)mapper.readValue(content, CallInviteContent.class);
            }
            case "m.direct": {
                return (EventContent)mapper.readValue(content, DirectContent.class);
            }
            case "m.forwarded_room_key": {
                return (EventContent)mapper.readValue(content, ForwardedRoomKeyContent.class);
            }
            case "m.fully_read": {
                return (EventContent)mapper.readValue(content, FullyReadContent.class);
            }
            case "m.ignored_user_list": {
                return (EventContent)mapper.readValue(content, IgnoredUserListContent.class);
            }
            case "m.presence": {
                return (EventContent)mapper.readValue(content, PresenceContent.class);
            }
            case "m.receipt": {
                return (EventContent)mapper.readValue(content, ReceiptContent.class);
            }
            case "m.room.aliases": {
                return (EventContent)mapper.readValue(content, RoomAliasesContent.class);
            }
            case "m.room.avatar": {
                return (EventContent)mapper.readValue(content, RoomAvatarContent.class);
            }
            case "m.room.canonical_alias": {
                return (EventContent)mapper.readValue(content, RoomCanonicalAliasContent.class);
            }
            case "m.room.create": {
                return (EventContent)mapper.readValue(content, RoomCreateContent.class);
            }
            case "m.room.guest_access": {
                return (EventContent)mapper.readValue(content, RoomGuestAccessContent.class);
            }
            case "m.room.encryption": {
                return (EventContent)mapper.readValue(content, RoomEncryptionContent.class);
            }
            case "m.room.encrypted": {
                return (EventContent)mapper.readValue(content, RoomEncryptedContent.class);
            }
            case "m.room.history_visibility": {
                return (EventContent)mapper.readValue(content, RoomHistoryVisibilityContent.class);
            }
            case "m.room.join_rules": {
                return (EventContent)mapper.readValue(content, RoomJoinRulesContent.class);
            }
            case "m.room_key": {
                return (EventContent)mapper.readValue(content, RoomKeyContent.class);
            }
            case "m.room_key_request": {
                return (EventContent)mapper.readValue(content, RoomKeyRequestContent.class);
            }
            case "m.room.member": {
                return (EventContent)mapper.readValue(content, RoomMemberContent.class);
            }
            case "m.room.message": {
                return (EventContent)mapper.readValue(content, RoomMessageContent.class);
            }
            case "m.room.message.feedback": {
                return (EventContent)mapper.readValue(content, RoomMessageFeedbackContent.class);
            }
            case "m.room.name": {
                return (EventContent)mapper.readValue(content, RoomNameContent.class);
            }
            case "m.room.pinned_events": {
                return (EventContent)mapper.readValue(content, RoomPinnedContent.class);
            }
            case "m.room.power_levels": {
                return (EventContent)mapper.readValue(content, RoomPowerLevelsContent.class);
            }
            case "m.room.redaction": {
                return (EventContent)mapper.readValue(content, RoomRedactionContent.class);
            }
            case "m.room.third_party_invite": {
                return (EventContent)mapper.readValue(content, RoomThirdPartyInviteContent.class);
            }
            case "m.room.topic": {
                return (EventContent)mapper.readValue(content, RoomTopicContent.class);
            }
            case "m.sticker": {
                return (EventContent)mapper.readValue(content, StickerContent.class);
            }
            case "m.tag": {
                return (EventContent)mapper.readValue(content, TagContent.class);
            }
            case "m.typing": {
                return (EventContent)mapper.readValue(content, TypingContent.class);
            }
            case "m.room.server_acl": {
                return (EventContent)mapper.readValue(content, RoomServerAclContent.class);
            }
        }
        return this.parse(content, mapper);
    }

    protected EventContent parse(byte[] content, ObjectMapper mapper) throws IOException {
        return new RawEventContent(mapper.readValue(content, Map.class));
    }
}

