/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.impl;

import io.github.ma1uta.matrix.AliasId;
import io.github.ma1uta.matrix.EventId;
import io.github.ma1uta.matrix.GroupId;
import io.github.ma1uta.matrix.Id;
import io.github.ma1uta.matrix.IdParser;
import io.github.ma1uta.matrix.IllegalId;
import io.github.ma1uta.matrix.RoomId;
import io.github.ma1uta.matrix.UnknownId;
import io.github.ma1uta.matrix.UserId;
import java.util.ArrayList;
import java.util.List;

public class MatrixIdParser
extends IdParser {
    public static final int DNS_NAME_LENGTH = 255;
    public static final int IPV6_LENGTH = 45;
    public static final int IPV4_PART_COUNT = 4;
    public static final int IPV4_LENGTH = 3;

    public Id parse(String mxid) {
        UnknownId id;
        int portIndex;
        String serverName;
        if (mxid == null) {
            return new IllegalId(" ", "mxid cannot be null.");
        }
        if (this.isBlank(mxid)) {
            return new IllegalId(" ", "mxid cannot be blank.");
        }
        char sigil = mxid.charAt(0);
        if ('$' == sigil) {
            return new EventId(mxid);
        }
        int colon = mxid.indexOf(":");
        if (colon == -1) {
            return new IllegalId(mxid, "Missing colon. MXID must follow pattern: <sigil><localpart>:<serverName>");
        }
        String localpart = mxid.substring(1, colon);
        String hostname = serverName = mxid.substring(colon + 1);
        int port = -1;
        ArrayList<Id.IdParseException> errors = new ArrayList<Id.IdParseException>();
        if (serverName.charAt(serverName.length() - 1) != ']' && (portIndex = serverName.lastIndexOf(":")) != -1) {
            try {
                port = Integer.parseInt(serverName.substring(portIndex));
                hostname = serverName.substring(0, portIndex);
            }
            catch (NumberFormatException e) {
                errors.add(new Id.IdParseException("Port must contains only digits."));
            }
        }
        this.validateHostname(hostname, errors);
        switch (sigil) {
            case '@': {
                this.validateLocalpart(localpart, errors);
                id = new UserId(localpart, hostname, port);
                break;
            }
            case '!': {
                id = new RoomId(localpart, hostname, port);
                break;
            }
            case '#': {
                id = new AliasId(localpart, hostname, port);
                break;
            }
            case '+': {
                this.validateLocalpart(localpart, errors);
                id = new GroupId(localpart, hostname, port);
                break;
            }
            default: {
                id = new UnknownId(mxid);
            }
        }
        if (!errors.isEmpty()) {
            id.errors(errors);
        }
        return id;
    }

    private boolean isBlank(String mxid) {
        boolean blank = true;
        for (char c : mxid.toCharArray()) {
            if (Character.isWhitespace(c)) continue;
            blank = false;
            break;
        }
        return blank;
    }

    protected void validateLocalpart(String localpart, List<Id.IdParseException> errors) {
        String lowerCase = localpart.toLowerCase();
        for (int i = 0; i < lowerCase.length(); ++i) {
            char ch = localpart.charAt(i);
            if (ch >= 'a' && ch <= 'z' || ch >= '0' && ch <= '9' || ch == '.' || ch == '_' || ch == '-' || ch == '=') continue;
            errors.add(new Id.IdParseException("Char " + ch + " should be from the set: [a-z0-9\\._-=]"));
        }
    }

    protected void validateHostname(String hostname, List<Id.IdParseException> errors) {
        if (this.validateIpv4Address(hostname, errors) || this.validateIpv6Address(hostname, errors)) {
            return;
        }
        this.validateDnsName(hostname, errors);
    }

    protected boolean validateIpv4Address(String ipv4Address, List<Id.IdParseException> errors) {
        String[] ipv4parts = ipv4Address.split("\\.");
        if (ipv4parts.length != 4) {
            return false;
        }
        for (int i = 0; i < 4; ++i) {
            if (this.validateIpv4Part(ipv4parts[i].toCharArray(), errors)) continue;
            return false;
        }
        return true;
    }

    protected boolean validateIpv4Part(char[] ipv4part, List<Id.IdParseException> errors) {
        if (ipv4part.length > 3) {
            errors.add(new Id.IdParseException("Length of the ipv4 part is longer than 3 symbols."));
        }
        for (char ipv4char : ipv4part) {
            if (Character.isDigit(ipv4char)) continue;
            return false;
        }
        return true;
    }

    protected boolean validateIpv6Address(String ipv6Address, List<Id.IdParseException> errors) {
        if (ipv6Address.charAt(0) != '[' || ipv6Address.charAt(ipv6Address.length() - 1) != ']') {
            return false;
        }
        if (ipv6Address.length() < 2) {
            return false;
        }
        if (ipv6Address.length() > 45) {
            return false;
        }
        for (int i = 0; i < ipv6Address.length(); ++i) {
            if (this.validateIpv6Char(ipv6Address.charAt(i))) continue;
            return false;
        }
        return true;
    }

    protected boolean validateIpv6Char(char ipv6char) {
        return Character.isDigit(ipv6char) || ipv6char >= 'a' && ipv6char <= 'f' || ipv6char >= 'A' && ipv6char <= 'F' || ipv6char == ':' || ipv6char == '.';
    }

    protected void validateDnsName(String dnsName, List<Id.IdParseException> errors) {
        if (dnsName.length() > 255) {
            errors.add(new Id.IdParseException("Dns name must be shorter than 255 symbols"));
        }
        for (int i = 0; i < dnsName.length(); ++i) {
            this.validateDnsChar(dnsName.charAt(i), errors);
        }
    }

    protected void validateDnsChar(char dnsChar, List<Id.IdParseException> errors) {
        if (!Character.isDigit(dnsChar) && !Character.isAlphabetic(dnsChar) && dnsChar != '-' && dnsChar != '.') {
            errors.add(new Id.IdParseException("Char '" + dnsChar + "' must be a digit, alphabetic, '-' or '.'"));
        }
    }
}

