/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.events;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.github.ma1uta.matrix.EventContent;
import io.github.ma1uta.matrix.events.messages.Audio;
import io.github.ma1uta.matrix.events.messages.Emote;
import io.github.ma1uta.matrix.events.messages.File;
import io.github.ma1uta.matrix.events.messages.Image;
import io.github.ma1uta.matrix.events.messages.Location;
import io.github.ma1uta.matrix.events.messages.Notice;
import io.github.ma1uta.matrix.events.messages.Text;
import io.github.ma1uta.matrix.events.messages.Video;
import io.github.ma1uta.matrix.events.nested.Relates;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

@ApiModel(description="This event is used when sending messages in a room. Messages are not limited to be text. The ``msgtype`` key outlines the type of message, e.g. text, audio, image, video, etc. The ``body`` key is text and MUST be used with every kind of ``msgtype`` as a fallback mechanism for when a client cannot render a message. This allows clients to display *something* even if it is just plain text.", subTypes={Audio.class, Emote.class, File.class, Image.class, Location.class, Notice.class, Text.class, Video.class})
public abstract class RoomMessage
implements EventContent {
    @ApiModelProperty(value="The textual representation of this message.")
    private String body;
    @ApiModelProperty(name="m.relates_to", value="Relates (reply, ...).")
    @JsonProperty(value="m.relates_to")
    private Relates relatesTo;

    @ApiModelProperty(value="Message type.", readOnly=true)
    @JsonProperty(value="msgtype", access=JsonProperty.Access.READ_ONLY)
    public abstract String getMsgtype();

    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public Relates getRelatesTo() {
        return this.relatesTo;
    }

    public void setRelatesTo(Relates relatesTo) {
        this.relatesTo = relatesTo;
    }
}

