/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.events;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.github.ma1uta.matrix.EventContent;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;

@ApiModel(description="This event type is used to forward keys for end-to-end encryption. Typically it is encrypted as an m.room.encrypted event, then sent as a to-device event.")
public class ForwardedRoomKey
implements EventContent {
    @ApiModelProperty(value="Required. The encryption algorithm the key in this event is to be used with.", required=true)
    private String algorithm;
    @ApiModelProperty(name="room_id", value="The room where the key is used.", required=true)
    @JsonProperty(value="room_id")
    private String roomId;
    @ApiModelProperty(name="sender_key", value="Required. The Curve25519 key of the device which initiated the session originally.", required=true)
    @JsonProperty(value="sender_key")
    private String senderKey;
    @ApiModelProperty(name="session_id", value="The ID of the session that the key is for.", required=true)
    @JsonProperty(value="session_id")
    private String sessionId;
    @ApiModelProperty(name="session_key", value="The key to be exchanged.", required=true)
    @JsonProperty(value="session_key")
    private String sessionKey;
    @ApiModelProperty(name="sender_claimed_ed25519_key", value="The Ed25519 key of the device which initiated the session originally. It is 'claimed' because the receiving device has no way to tell that the original room_key actually came from a device which owns the private partof this key unless they have done device verification.", required=true)
    @JsonProperty(value="sender_claimed_ed25519_key")
    private String senderClaimedEd25519Key;
    @ApiModelProperty(name="forwarding_curve25519_key_chain", value="Chain of Curve25519 keys. It starts out empty, but each time the key is forwarded to another device, the previous sender in the chain is added to the end of the list. For example, if the key is forwarded from A to B to C, this field is empty between A and B, and contains A's Curve25519 key between B and C.", required=true)
    @JsonProperty(value="forwarding_curve25519_key_chain")
    private List<String> forwardingCurve25519KeyChain;

    public String getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    public String getRoomId() {
        return this.roomId;
    }

    public void setRoomId(String roomId) {
        this.roomId = roomId;
    }

    public String getSenderKey() {
        return this.senderKey;
    }

    public void setSenderKey(String senderKey) {
        this.senderKey = senderKey;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public String getSessionKey() {
        return this.sessionKey;
    }

    public void setSessionKey(String sessionKey) {
        this.sessionKey = sessionKey;
    }

    public String getSenderClaimedEd25519Key() {
        return this.senderClaimedEd25519Key;
    }

    public void setSenderClaimedEd25519Key(String senderClaimedEd25519Key) {
        this.senderClaimedEd25519Key = senderClaimedEd25519Key;
    }

    public List<String> getForwardingCurve25519KeyChain() {
        return this.forwardingCurve25519KeyChain;
    }

    public void setForwardingCurve25519KeyChain(List<String> forwardingCurve25519KeyChain) {
        this.forwardingCurve25519KeyChain = forwardingCurve25519KeyChain;
    }
}

